/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.bukkit.api.CraftEngineFurniture;
import net.momirealms.craftengine.bukkit.entity.furniture.BukkitFurnitureManager;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.core.entity.furniture.AnchorType;
import net.momirealms.craftengine.core.entity.furniture.CustomFurniture;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.command.FlagKeys;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.bukkit.parser.NamespacedKeyParser;
import net.momirealms.craftengine.libraries.cloud.bukkit.parser.location.LocationParser;
import net.momirealms.craftengine.libraries.cloud.context.CommandContext;
import net.momirealms.craftengine.libraries.cloud.context.CommandInput;
import net.momirealms.craftengine.libraries.cloud.parser.standard.EnumParser;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.suggestion.SuggestionProvider;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DebugSpawnFurnitureCommand
extends BukkitCommandFeature<CommandSender> {
    public DebugSpawnFurnitureCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.required("location", LocationParser.locationParser()).required("id", NamespacedKeyParser.namespacedKeyComponent().suggestionProvider((SuggestionProvider)new SuggestionProvider<Object>(){

            public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<Object> context, @NonNull CommandInput input) {
                return CompletableFuture.completedFuture(DebugSpawnFurnitureCommand.this.plugin().furnitureManager().cachedSuggestions());
            }
        })).optional("anchor-type", EnumParser.enumParser(AnchorType.class)).flag(FlagKeys.SILENT_FLAG).handler(context -> {
            NamespacedKey namespacedKey = (NamespacedKey)context.get("id");
            Key id = KeyUtils.namespacedKey2Key(namespacedKey);
            BukkitFurnitureManager furnitureManager = BukkitFurnitureManager.instance();
            Optional<CustomFurniture> optionalCustomFurniture = furnitureManager.furnitureById(id);
            if (optionalCustomFurniture.isEmpty()) {
                return;
            }
            Location location = (Location)context.get("location");
            CustomFurniture customFurniture = optionalCustomFurniture.get();
            AnchorType anchorType = context.optional("anchor-type").orElse(customFurniture.getAnyAnchorType());
            boolean playSound = context.flags().hasFlag("silent");
            CraftEngineFurniture.place(location, customFurniture, anchorType, playSound);
        });
    }

    @Override
    public String getFeatureID() {
        return "debug_spawn_furniture";
    }
}

