/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.Collection;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.command.FlagKeys;
import net.momirealms.craftengine.core.plugin.locale.MessageConstants;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.bukkit.data.MultiplePlayerSelector;
import net.momirealms.craftengine.libraries.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SendResourcePackCommand
extends BukkitCommandFeature<CommandSender> {
    public SendResourcePackCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.flag(FlagKeys.SILENT_FLAG).required("player", MultiplePlayerSelectorParser.multiplePlayerSelectorParser((boolean)true)).handler(context -> {
            MultiplePlayerSelector selector = (MultiplePlayerSelector)context.get("player");
            Collection players = selector.values();
            for (Player player : players) {
                BukkitServerPlayer bukkitServerPlayer = this.plugin().adapt(player);
                if (bukkitServerPlayer == null) continue;
                BukkitCraftEngine.instance().packManager().sendResourcePack(bukkitServerPlayer);
            }
            int size = players.size();
            if (size == 1) {
                String name = ((Player)players.iterator().next()).getName();
                this.handleFeedback(context, MessageConstants.COMMAND_SEND_RESOURCE_PACK_SUCCESS_SINGLE, new Component[]{Component.text((String)name)});
            } else {
                this.handleFeedback(context, MessageConstants.COMMAND_SEND_RESOURCE_PACK_SUCCESS_MULTIPLE, new Component[]{Component.text((int)size)});
            }
        });
    }

    @Override
    public String getFeatureID() {
        return "send_resource_pack";
    }
}

