/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.scheduler.impl;

import java.util.Optional;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.scheduler.impl.FoliaTask;
import net.momirealms.craftengine.core.plugin.scheduler.RegionExecutor;
import net.momirealms.craftengine.core.plugin.scheduler.SchedulerTask;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FoliaExecutor
implements RegionExecutor<World> {
    private final BukkitCraftEngine plugin;

    public FoliaExecutor(BukkitCraftEngine plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run(Runnable runnable, World world, int x, int z) {
        Optional.ofNullable(world).ifPresentOrElse(w -> Bukkit.getRegionScheduler().execute((Plugin)this.plugin.javaPlugin(), w, x, z, runnable), () -> Bukkit.getGlobalRegionScheduler().execute((Plugin)this.plugin.javaPlugin(), runnable));
    }

    @Override
    public void runDelayed(Runnable runnable, World world, int x, int z) {
        this.run(runnable, world, x, z);
    }

    @Override
    public SchedulerTask runAsyncRepeating(Runnable runnable, long delay, long period) {
        return this.runRepeating(runnable, delay, period, null, 0, 0);
    }

    @Override
    public SchedulerTask runAsyncLater(Runnable runnable, long delay) {
        return this.runLater(runnable, delay, null, 0, 0);
    }

    @Override
    public SchedulerTask runLater(Runnable runnable, long delay, World world, int x, int z) {
        if (world == null) {
            if (delay <= 0L) {
                return new FoliaTask(Bukkit.getGlobalRegionScheduler().run((Plugin)this.plugin.javaPlugin(), scheduledTask -> runnable.run()));
            }
            return new FoliaTask(Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin.javaPlugin(), scheduledTask -> runnable.run(), delay));
        }
        if (delay <= 0L) {
            return new FoliaTask(Bukkit.getRegionScheduler().run((Plugin)this.plugin.javaPlugin(), world, x, z, scheduledTask -> runnable.run()));
        }
        return new FoliaTask(Bukkit.getRegionScheduler().runDelayed((Plugin)this.plugin.javaPlugin(), world, x, z, scheduledTask -> runnable.run(), delay));
    }

    @Override
    public SchedulerTask runRepeating(Runnable runnable, long delay, long period, World world, int x, int z) {
        if (world == null) {
            return new FoliaTask(Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin.javaPlugin(), scheduledTask -> runnable.run(), delay, period));
        }
        return new FoliaTask(Bukkit.getRegionScheduler().runAtFixedRate((Plugin)this.plugin.javaPlugin(), world, x, z, scheduledTask -> runnable.run(), delay, period));
    }

    @Override
    public void execute(@NotNull Runnable runnable) {
        Bukkit.getGlobalRegionScheduler().execute((Plugin)this.plugin.javaPlugin(), runnable);
    }
}

