/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.util;

import net.momirealms.craftengine.core.util.VersionHelper;

public class EntityDataUtils {
    private static final int HAS_SHADOW = 1;
    private static final int IS_SEE_THROUGH = 2;
    private static final int USE_DEFAULT_BACKGROUND = 4;
    private static final int LEFT_ALIGNMENT = 8;
    private static final int RIGHT_ALIGNMENT = 16;
    public static final int BLOCK_STATE_DATA_ID = VersionHelper.isOrAbove1_20_2() ? 23 : 22;
    public static final int TEXT_DATA_ID = VersionHelper.isOrAbove1_20_2() ? 23 : 22;
    public static final int DISPLAYED_ITEM_DATA_ID = VersionHelper.isOrAbove1_20_2() ? 23 : 22;
    public static final int CUSTOM_NAME_DATA_ID = 2;
    public static final int ITEM_DATA_ID = 8;
    public static final int ITEM_FRAME_DATA_ID = VersionHelper.isOrAbove1_21_6() ? 9 : 8;
    private static final int IS_ON_FIRE = 1;
    private static final int IS_CROUCHING = 2;
    private static final int UNUSED = 4;
    private static final int IS_SPRINTING = 8;
    private static final int IS_SWIMMING = 16;
    private static final int IS_INVISIBLE = 32;
    private static final int HAS_GLOWING_EFFECT = 64;
    private static final int IS_FLYING_WITH_ELYTRA = 128;

    private EntityDataUtils() {
    }

    public static byte encodeTextDisplayMask(boolean hasShadow, boolean isSeeThrough, boolean useDefaultBackground, int alignment) {
        int bitMask = 0;
        if (hasShadow) {
            bitMask |= 1;
        }
        if (isSeeThrough) {
            bitMask |= 2;
        }
        if (useDefaultBackground) {
            bitMask |= 4;
        }
        switch (alignment) {
            case 0: {
                break;
            }
            case 1: {
                bitMask |= 8;
                break;
            }
            case 2: {
                bitMask |= 0x10;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid alignment value");
            }
        }
        return (byte)bitMask;
    }

    public static byte encodeCommonMask(boolean isOnFire, boolean isCrouching, boolean isUnused, boolean isSprinting, boolean isSwimming, boolean isInvisible, boolean hasGlowingEffect, boolean isFlyingWithElytra) {
        int bitMask = 0;
        if (isOnFire) {
            bitMask |= 1;
        }
        if (isCrouching) {
            bitMask |= 2;
        }
        if (isUnused) {
            bitMask |= 4;
        }
        if (isSprinting) {
            bitMask |= 8;
        }
        if (isSwimming) {
            bitMask |= 0x10;
        }
        if (isInvisible) {
            bitMask |= 0x20;
        }
        if (hasGlowingEffect) {
            bitMask |= 0x40;
        }
        if (isFlyingWithElytra) {
            bitMask |= 0x80;
        }
        return (byte)bitMask;
    }

    public static boolean isCrouching(byte mask) {
        return (mask & 2) != 0;
    }
}

