/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.util;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.jetbrains.annotations.Nullable;

public class MaterialUtils {
    public static Material MACE;

    private MaterialUtils() {
    }

    @Nullable
    public static Material getMaterial(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        if (name.contains(":")) {
            return (Material)Registry.MATERIAL.get(Objects.requireNonNull(NamespacedKey.fromString((String)name)));
        }
        NamespacedKey key = NamespacedKey.minecraft((String)name.toLowerCase(Locale.ENGLISH));
        return Optional.ofNullable((Material)Registry.MATERIAL.get(key)).orElseGet(() -> {
            try {
                return Material.valueOf((String)name.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        });
    }

    public static Material getMaterial(Key key) {
        return (Material)Registry.MATERIAL.get(Objects.requireNonNull(NamespacedKey.fromString((String)key.toString())));
    }

    static {
        try {
            MACE = Material.valueOf((String)"MACE");
        }
        catch (Exception ignore) {
            MACE = null;
        }
    }
}

