/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.registry.Holder;
import org.jetbrains.annotations.Nullable;

public class BlockStateHolder {
    protected final Holder<CustomBlock> owner;
    private final Reference2ObjectArrayMap<Property<?>, Comparable<?>> propertyMap;
    private Map<Property<?>, ImmutableBlockState[]> withMap;

    public BlockStateHolder(Holder<CustomBlock> owner, Reference2ObjectArrayMap<Property<?>, Comparable<?>> propertyMap) {
        this.owner = owner;
        this.propertyMap = new Reference2ObjectArrayMap(propertyMap);
    }

    public Holder<CustomBlock> owner() {
        return this.owner;
    }

    public <T extends Comparable<T>> ImmutableBlockState cycle(Property<T> property) {
        T currentValue = this.get(property);
        List<T> values = property.possibleValues();
        return this.with(property, (Comparable)BlockStateHolder.getNextValue(values, currentValue));
    }

    protected static <T> T getNextValue(List<T> values, T currentValue) {
        int index = values.indexOf(currentValue);
        if (index == -1) {
            throw new IllegalArgumentException("Current value not found in possible values");
        }
        return values.get((index + 1) % values.size());
    }

    public String toString() {
        if (this.propertyMap.isEmpty()) {
            return this.owner.value().id().toString();
        }
        return String.valueOf(this.owner.value().id()) + "[" + this.getPropertiesAsString() + "]";
    }

    public String getPropertiesAsString() {
        return this.propertyMap.entrySet().stream().map(entry -> {
            Property property = (Property)entry.getKey();
            return property.name() + "=" + Property.formatValue(property, (Comparable)entry.getValue());
        }).collect(Collectors.joining(","));
    }

    public Collection<Property<?>> getProperties() {
        return Collections.unmodifiableSet(this.propertyMap.keySet());
    }

    public <T extends Comparable<T>> boolean contains(Property<T> property) {
        return this.propertyMap.containsKey(property);
    }

    public <T extends Comparable<T>> T get(Property<T> property) {
        T value = this.getNullable(property);
        if (value == null) {
            throw new IllegalArgumentException("Property " + String.valueOf(property) + " not found in " + String.valueOf(this.owner.value().id()));
        }
        return value;
    }

    public <T extends Comparable<T>> T get(Property<T> property, T fallback) {
        return (T)((Comparable)Objects.requireNonNullElse(this.getNullable(property), fallback));
    }

    @Nullable
    public <T extends Comparable<T>> T getNullable(Property<T> property) {
        Comparable value = (Comparable)this.propertyMap.get(property);
        return (T)(value != null ? (Comparable)property.valueClass().cast(value) : null);
    }

    public <T extends Comparable<T>, V extends T> ImmutableBlockState with(Property<T> property, V value) {
        if (!this.propertyMap.containsKey(property)) {
            throw new IllegalArgumentException("Property " + String.valueOf(property) + " not found in " + String.valueOf(this.owner.value().id()));
        }
        return this.withInternal(property, value);
    }

    private <T extends Comparable<T>, V extends T> ImmutableBlockState withInternal(Property<T> property, V newValue) {
        if (newValue.equals(this.propertyMap.get(property))) {
            return (ImmutableBlockState)this;
        }
        int index = property.indexOf(newValue);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid value " + String.valueOf(newValue) + " for property " + String.valueOf(property));
        }
        return this.withMap.get(property)[index];
    }

    public void createWithMap(Map<Map<Property<?>, Comparable<?>>, ImmutableBlockState> states) {
        if (this.withMap != null) {
            throw new IllegalStateException("WithMap already initialized");
        }
        Reference2ObjectArrayMap map = new Reference2ObjectArrayMap(this.propertyMap.size());
        for (Property property : this.propertyMap.keySet()) {
            ImmutableBlockState[] statesArray = (ImmutableBlockState[])property.possibleValues().stream().map(value -> {
                Reference2ObjectArrayMap testMap = new Reference2ObjectArrayMap(this.propertyMap);
                testMap.put(property, value);
                ImmutableBlockState state = (ImmutableBlockState)states.get(testMap);
                if (state == null) {
                    throw new IllegalStateException("Missing state for " + String.valueOf(testMap));
                }
                return state;
            }).toArray(ImmutableBlockState[]::new);
            map.put((Object)property, (Object)statesArray);
        }
        this.withMap = Map.copyOf(map);
    }

    public Map<Property<?>, Comparable<?>> propertyEntries() {
        return Collections.unmodifiableMap(this.propertyMap);
    }
}

