/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block.properties;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.block.properties.PropertyFactory;
import net.momirealms.craftengine.libraries.nbt.StringTag;
import net.momirealms.craftengine.libraries.nbt.Tag;

public class EnumProperty<T extends Enum<T>>
extends Property<T> {
    private final List<T> values;
    private final Map<String, T> names;
    private final int[] ordinalToIndex;
    private final int[] idLookupTable;

    public EnumProperty(String name, Class<T> type, List<T> values, T defaultValue) {
        super(name, type, defaultValue);
        this.values = List.copyOf(values);
        Enum[] enums = (Enum[])type.getEnumConstants();
        this.ordinalToIndex = new int[enums.length];
        for (Enum enum_ : enums) {
            this.ordinalToIndex[enum_.ordinal()] = values.indexOf(enum_);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Enum enum2 : values) {
            String string = enum2.name().toLowerCase(Locale.ENGLISH);
            builder.put((Object)string, (Object)enum2);
        }
        this.names = builder.buildOrThrow();
        Class clazz = this.valueClass();
        int id = 0;
        this.idLookupTable = new int[((Enum[])clazz.getEnumConstants()).length];
        Arrays.fill(this.idLookupTable, -1);
        Enum[] byId = (Enum[])Array.newInstance(clazz, values.size());
        for (Enum value : values) {
            int valueId;
            this.idLookupTable[value.ordinal()] = valueId = id++;
            byId[valueId] = value;
        }
        this.setById((Comparable[])byId);
    }

    @Override
    public List<T> possibleValues() {
        return this.values;
    }

    @Override
    public Optional<T> optional(String valueName) {
        return Optional.ofNullable((Enum)this.names.get(valueName));
    }

    @Override
    public Optional<Tag> createOptionalTag(String valueName) {
        return this.optional(valueName).map(it -> new StringTag(((Enum)this.names.get(valueName)).name().toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Tag pack(T value) {
        return new StringTag(this.valueName(value));
    }

    @Override
    public T unpack(Tag tag) {
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            return (T)((Enum)this.names.get(stringTag.getAsString()));
        }
        throw new IllegalArgumentException("Invalid string tag: " + String.valueOf(tag));
    }

    @Override
    public final int idFor(T value) {
        Class target = this.valueClass();
        return value.getClass() != target && ((Enum)value).getDeclaringClass() != target ? -1 : this.idLookupTable[((Enum)value).ordinal()];
    }

    @Override
    public String valueName(T value) {
        return ((Enum)value).name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public int indexOf(T value) {
        return this.ordinalToIndex[((Enum)value).ordinal()];
    }

    @Override
    public int generateHashCode() {
        int i = super.generateHashCode();
        return 31 * i + this.values.hashCode();
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String name, Class<T> type, List<T> values, T defaultValue) {
        return new EnumProperty<T>(name, type, values, defaultValue);
    }

    public static class Factory<A extends Enum<A>>
    implements PropertyFactory {
        private final Class<A> enumClass;

        public Factory(Class<A> enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        public Property<?> create(String name, Map<String, Object> arguments) {
            List<Enum> enums = Arrays.asList((Enum[])this.enumClass.getEnumConstants());
            String defaultValueName = arguments.getOrDefault("default", "").toString().toLowerCase(Locale.ENGLISH);
            Enum defaultValue = enums.stream().filter(e -> e.name().toLowerCase(Locale.ENGLISH).equals(defaultValueName)).findFirst().orElseGet(() -> (Enum)enums.get(0));
            return EnumProperty.create(name, this.enumClass, enums, defaultValue);
        }
    }
}

