/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block.properties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.item.context.BlockPlaceContext;
import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.HorizontalDirection;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public abstract class Property<T extends Comparable<T>> {
    public static final Map<String, Function<Property<?>, BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState>>> HARD_CODED_PLACEMENTS = new HashMap();
    private final Class<T> clazz;
    private final String name;
    @Nullable
    private Integer hashCode;
    private static final AtomicInteger ID_GENERATOR;
    private final int id;
    private final T defaultValue;
    private T[] byId;
    private int defaultValueIndex;

    protected Property(String name, Class<T> clazz, T defaultValue) {
        this.clazz = clazz;
        this.name = name;
        this.id = ID_GENERATOR.getAndIncrement();
        this.defaultValue = defaultValue;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public int defaultValueIndex() {
        return this.defaultValueIndex;
    }

    public int id() {
        return this.id;
    }

    public T byId(int id) {
        T[] byId = this.byId;
        return id < 0 || id >= byId.length ? null : (T)this.byId[id];
    }

    protected void setById(T[] byId) {
        if (this.byId != null) {
            throw new IllegalStateException();
        }
        this.byId = byId;
        this.defaultValueIndex = this.indexOf(this.defaultValue);
    }

    public Value<T> value(T value) {
        return new Value<T>(this, value);
    }

    public abstract int idFor(T var1);

    public abstract String valueName(T var1);

    public abstract List<T> possibleValues();

    public abstract Optional<T> optional(String var1);

    public abstract Optional<Tag> createOptionalTag(String var1);

    public abstract Tag pack(T var1);

    public int indexOf(Tag tag) {
        return this.indexOf(this.unpack(tag));
    }

    public abstract int indexOf(T var1);

    public abstract T unpack(Tag var1);

    public String name() {
        return this.name;
    }

    public Class<T> valueClass() {
        return this.clazz;
    }

    public final int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.generateHashCode();
        }
        return this.hashCode;
    }

    protected int generateHashCode() {
        return 31 * this.clazz.hashCode() + this.name.hashCode();
    }

    public static BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState> createStateForPlacement(String id, Property<?> property) {
        return Optional.ofNullable(HARD_CODED_PLACEMENTS.get(id)).map(it -> (BiFunction)it.apply(property)).orElse((context, state) -> ImmutableBlockState.with(state, property, property.defaultValue()));
    }

    public static <T extends Comparable<T>> String formatValue(Property<T> property, Comparable<?> value) {
        return property.valueName(value);
    }

    static {
        HARD_CODED_PLACEMENTS.put("axis", property -> {
            Property axisProperty = property;
            return (context, state) -> state.with(axisProperty, context.getClickedFace().axis());
        });
        HARD_CODED_PLACEMENTS.put("facing", property -> {
            if (property.valueClass() == HorizontalDirection.class) {
                Property directionProperty = property;
                return (context, state) -> state.with(directionProperty, context.getHorizontalDirection().opposite().toHorizontalDirection());
            }
            if (property.valueClass() == Direction.class) {
                Property directionProperty = property;
                return (context, state) -> state.with(directionProperty, context.getNearestLookingDirection().opposite());
            }
            throw new IllegalArgumentException("Unsupported property type used in hard-coded `facing` property: " + String.valueOf(property.valueClass()));
        });
        HARD_CODED_PLACEMENTS.put("facing_clockwise", property -> {
            if (property.valueClass() == HorizontalDirection.class) {
                Property directionProperty = property;
                return (context, state) -> state.with(directionProperty, context.getHorizontalDirection().clockWise().toHorizontalDirection());
            }
            throw new IllegalArgumentException("Unsupported property type used in hard-coded `facing_clockwise` property: " + String.valueOf(property.valueClass()));
        });
        HARD_CODED_PLACEMENTS.put("waterlogged", property -> {
            Property waterloggedProperty = property;
            return (context, state) -> state.with(waterloggedProperty, context.isWaterSource());
        });
        ID_GENERATOR = new AtomicInteger();
    }

    public record Value<T extends Comparable<T>>(Property<T> property, T value) {
        public Value {
            if (!property.possibleValues().contains(value)) {
                throw new IllegalArgumentException("Value " + String.valueOf(value) + " does not belong to property " + String.valueOf(property));
            }
        }

        @Override
        public String toString() {
            return this.property.name + "=" + this.property.valueName(this.value);
        }
    }
}

