/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.entity.furniture;

import java.util.function.Function;
import net.momirealms.craftengine.core.util.Pair;

public enum AlignmentRule {
    ANY(Function.identity()),
    CORNER(pair -> {
        double p1 = Math.round((Double)pair.left());
        double p2 = Math.round((Double)pair.right());
        return new Pair<Double, Double>(p1, p2);
    }),
    CENTER(pair -> {
        double p1 = Math.floor((Double)pair.left()) + 0.5;
        double p2 = Math.floor((Double)pair.right()) + 0.5;
        return new Pair<Double, Double>(p1, p2);
    }),
    HALF(pair -> {
        double p1 = (double)Math.round((Double)pair.left() * 2.0) / 2.0;
        double p2 = (double)Math.round((Double)pair.right() * 2.0) / 2.0;
        return new Pair<Double, Double>(p1, p2);
    }),
    QUARTER(pair -> {
        double p1 = (double)Math.round((Double)pair.left() * 4.0) / 4.0;
        double p2 = (double)Math.round((Double)pair.right() * 4.0) / 4.0;
        return new Pair<Double, Double>(p1, p2);
    });

    private final Function<Pair<Double, Double>, Pair<Double, Double>> function;

    private AlignmentRule(Function<Pair<Double, Double>, Pair<Double, Double>> function) {
        this.function = function;
    }

    public Pair<Double, Double> apply(Pair<Double, Double> pair) {
        return this.function.apply(pair);
    }
}

