/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.entity.furniture;

import java.util.HashMap;
import java.util.Map;
import net.momirealms.craftengine.core.entity.furniture.FurnitureSounds;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import org.jetbrains.annotations.Nullable;

public class FurnitureSettings {
    boolean minimized;
    FurnitureSounds sounds = FurnitureSounds.EMPTY;
    @Nullable
    Key itemId;

    private FurnitureSettings() {
    }

    public static FurnitureSettings of() {
        return new FurnitureSettings();
    }

    public static FurnitureSettings fromMap(Map<String, Object> map) {
        return FurnitureSettings.applyModifiers(FurnitureSettings.of(), map);
    }

    public static FurnitureSettings ofFullCopy(FurnitureSettings settings) {
        FurnitureSettings newSettings = FurnitureSettings.of();
        newSettings.sounds = settings.sounds;
        newSettings.itemId = settings.itemId;
        newSettings.minimized = settings.minimized;
        return newSettings;
    }

    public static FurnitureSettings applyModifiers(FurnitureSettings settings, Map<String, Object> map) {
        if (map == null) {
            return settings;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Modifier.Factory factory = Modifiers.FACTORIES.get(entry.getKey());
            if (factory != null) {
                factory.createModifier(entry.getValue()).apply(settings);
                continue;
            }
            throw new LocalizedResourceConfigException("warning.config.furniture.settings.unknown", entry.getKey());
        }
        return settings;
    }

    public FurnitureSounds sounds() {
        return this.sounds;
    }

    public boolean minimized() {
        return this.minimized;
    }

    @Nullable
    public Key itemId() {
        return this.itemId;
    }

    public FurnitureSettings sounds(FurnitureSounds sounds) {
        this.sounds = sounds;
        return this;
    }

    public FurnitureSettings itemId(Key itemId) {
        this.itemId = itemId;
        return this;
    }

    public FurnitureSettings minimized(boolean minimized) {
        this.minimized = minimized;
        return this;
    }

    public static class Modifiers {
        private static final Map<String, Modifier.Factory> FACTORIES = new HashMap<String, Modifier.Factory>();

        private static void registerFactory(String id, Modifier.Factory factory) {
            FACTORIES.put(id, factory);
        }

        static {
            Modifiers.registerFactory("sounds", value -> {
                Map<String, Object> sounds = MiscUtils.castToMap(value, false);
                return settings -> settings.sounds(FurnitureSounds.fromMap(sounds));
            });
            Modifiers.registerFactory("item", value -> {
                String item = value.toString();
                return settings -> settings.itemId(Key.of(item));
            });
            Modifiers.registerFactory("minimized", value -> {
                boolean bool = (Boolean)value;
                return settings -> settings.minimized(bool);
            });
        }
    }

    @FunctionalInterface
    public static interface Modifier {
        public void apply(FurnitureSettings var1);

        @FunctionalInterface
        public static interface Factory {
            public Modifier createModifier(Object var1);
        }
    }
}

