/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.font;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import net.momirealms.craftengine.core.util.CharacterUtils;
import net.momirealms.craftengine.libraries.adventure.key.Key;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.boostedyaml.block.implementation.Section;
import net.momirealms.craftengine.libraries.caffeine.cache.Cache;
import net.momirealms.craftengine.libraries.caffeine.cache.Caffeine;

public class OffsetFont {
    private final String font;
    private final Key fontKey;
    private final String NEG_16;
    private final String NEG_24;
    private final String NEG_32;
    private final String NEG_48;
    private final String NEG_64;
    private final String NEG_128;
    private final String NEG_256;
    private final String POS_16;
    private final String POS_24;
    private final String POS_32;
    private final String POS_48;
    private final String POS_64;
    private final String POS_128;
    private final String POS_256;
    private final String[] negativeOffsets = new String[16];
    private final String[] positiveOffsets = new String[16];
    private final Cache<Integer, String> fastLookup = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(256L).build();

    public OffsetFont(Section section) {
        this.font = section.getString("font", "minecraft:default");
        this.fontKey = Key.key((String)this.font);
        this.NEG_16 = this.convertIfUnicode(section.getString("-16", ""));
        this.NEG_24 = this.convertIfUnicode(section.getString("-24", ""));
        this.NEG_32 = this.convertIfUnicode(section.getString("-32", ""));
        this.NEG_48 = this.convertIfUnicode(section.getString("-48", ""));
        this.NEG_64 = this.convertIfUnicode(section.getString("-64", ""));
        this.NEG_128 = this.convertIfUnicode(section.getString("-128", ""));
        this.NEG_256 = this.convertIfUnicode(section.getString("-256", ""));
        this.POS_16 = this.convertIfUnicode(section.getString("16", ""));
        this.POS_24 = this.convertIfUnicode(section.getString("24", ""));
        this.POS_32 = this.convertIfUnicode(section.getString("32", ""));
        this.POS_48 = this.convertIfUnicode(section.getString("48", ""));
        this.POS_64 = this.convertIfUnicode(section.getString("64", ""));
        this.POS_128 = this.convertIfUnicode(section.getString("128", ""));
        this.POS_256 = this.convertIfUnicode(section.getString("256", ""));
        for (int i = 1; i <= 15; ++i) {
            this.negativeOffsets[i] = this.convertIfUnicode(section.getString("-" + i, ""));
            this.positiveOffsets[i] = this.convertIfUnicode(section.getString(String.valueOf(i), ""));
        }
    }

    public Component createOffset(int offset) {
        if (offset == 0) {
            return Component.empty();
        }
        return Component.text((String)Objects.requireNonNull((String)this.fastLookup.get((Object)offset, k -> k > 0 ? this.createPos((int)k) : this.createNeg(-k.intValue())))).font(this.fontKey);
    }

    public String createOffset(int offset, BiFunction<String, String, String> tagDecorator) {
        if (offset == 0) {
            return "";
        }
        return tagDecorator.apply((String)this.fastLookup.get((Object)offset, k -> k > 0 ? this.createPos((int)k) : this.createNeg(-k.intValue())), this.font);
    }

    private String createPos(int offset) {
        StringBuilder stringBuilder = new StringBuilder();
        while (offset >= 256) {
            stringBuilder.append(this.POS_256);
            offset -= 256;
        }
        if (offset >= 128) {
            stringBuilder.append(this.POS_128);
            offset -= 128;
        }
        if (offset >= 64) {
            stringBuilder.append(this.POS_64);
            offset -= 64;
        }
        if (offset >= 48) {
            stringBuilder.append(this.POS_48);
            offset -= 48;
        }
        if (offset >= 32) {
            stringBuilder.append(this.POS_32);
            offset -= 32;
        }
        if (offset >= 24) {
            stringBuilder.append(this.POS_24);
            offset -= 24;
        }
        if (offset >= 16) {
            stringBuilder.append(this.POS_16);
            offset -= 16;
        }
        if (offset == 0) {
            return stringBuilder.toString();
        }
        stringBuilder.append(this.positiveOffsets[offset]);
        return stringBuilder.toString();
    }

    private String createNeg(int offset) {
        StringBuilder stringBuilder = new StringBuilder();
        while (offset >= 256) {
            stringBuilder.append(this.NEG_256);
            offset -= 256;
        }
        if (offset >= 128) {
            stringBuilder.append(this.NEG_128);
            offset -= 128;
        }
        if (offset >= 64) {
            stringBuilder.append(this.NEG_64);
            offset -= 64;
        }
        if (offset >= 48) {
            stringBuilder.append(this.NEG_48);
            offset -= 48;
        }
        if (offset >= 32) {
            stringBuilder.append(this.NEG_32);
            offset -= 32;
        }
        if (offset >= 24) {
            stringBuilder.append(this.NEG_24);
            offset -= 24;
        }
        if (offset >= 16) {
            stringBuilder.append(this.NEG_16);
            offset -= 16;
        }
        if (offset == 0) {
            return stringBuilder.toString();
        }
        stringBuilder.append(this.negativeOffsets[offset]);
        return stringBuilder.toString();
    }

    private String convertIfUnicode(String s) {
        if (s.startsWith("\\u")) {
            return new String(CharacterUtils.decodeUnicodeToChars(this.font));
        }
        return s;
    }
}

