/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.ExternalItemSource;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.item.ItemManager;
import net.momirealms.craftengine.core.item.ItemSettings;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.behavior.ItemBehaviors;
import net.momirealms.craftengine.core.item.equipment.ComponentBasedEquipment;
import net.momirealms.craftengine.core.item.equipment.Equipment;
import net.momirealms.craftengine.core.item.equipment.EquipmentLayerType;
import net.momirealms.craftengine.core.item.equipment.Equipments;
import net.momirealms.craftengine.core.item.equipment.TrimBasedEquipment;
import net.momirealms.craftengine.core.item.modifier.CustomModelDataModifier;
import net.momirealms.craftengine.core.item.modifier.IdModifier;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifiers;
import net.momirealms.craftengine.core.item.modifier.ItemModelModifier;
import net.momirealms.craftengine.core.pack.AbstractPackManager;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.pack.ResourceLocation;
import net.momirealms.craftengine.core.pack.model.BaseItemModel;
import net.momirealms.craftengine.core.pack.model.ConditionItemModel;
import net.momirealms.craftengine.core.pack.model.ItemModel;
import net.momirealms.craftengine.core.pack.model.ItemModels;
import net.momirealms.craftengine.core.pack.model.LegacyItemModel;
import net.momirealms.craftengine.core.pack.model.LegacyModelPredicate;
import net.momirealms.craftengine.core.pack.model.LegacyOverridesModel;
import net.momirealms.craftengine.core.pack.model.ModernItemModel;
import net.momirealms.craftengine.core.pack.model.RangeDispatchItemModel;
import net.momirealms.craftengine.core.pack.model.SelectItemModel;
import net.momirealms.craftengine.core.pack.model.SpecialItemModel;
import net.momirealms.craftengine.core.pack.model.condition.ConditionProperty;
import net.momirealms.craftengine.core.pack.model.generation.AbstractModelGenerator;
import net.momirealms.craftengine.core.pack.model.generation.ModelGeneration;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchProperty;
import net.momirealms.craftengine.core.pack.model.select.ChargeTypeSelectProperty;
import net.momirealms.craftengine.core.pack.model.select.SelectProperty;
import net.momirealms.craftengine.core.pack.model.select.TrimMaterialSelectProperty;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventFunctions;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.util.ExceptionCollector;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MinecraftVersions;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.UniqueKey;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.type.Either;

public abstract class AbstractItemManager<I>
extends AbstractModelGenerator
implements ItemManager<I> {
    protected static final Map<Key, List<ItemBehavior>> VANILLA_ITEM_EXTRA_BEHAVIORS = new HashMap<Key, List<ItemBehavior>>();
    protected static final Set<Key> VANILLA_ITEMS = new HashSet<Key>(1024);
    protected static final Map<Key, List<UniqueKey>> VANILLA_ITEM_TAGS = new HashMap<Key, List<UniqueKey>>();
    private final ItemParser itemParser;
    private final EquipmentParser equipmentParser;
    protected final Map<String, ExternalItemSource<I>> externalItemSources = new HashMap<String, ExternalItemSource<I>>();
    protected final Map<Key, CustomItem<I>> customItems = new HashMap<Key, CustomItem<I>>();
    protected final Map<Key, List<UniqueKey>> customItemTags = new HashMap<Key, List<UniqueKey>>();
    protected final Map<Key, Map<Integer, Key>> cmdConflictChecker = new HashMap<Key, Map<Integer, Key>>();
    protected final Map<Key, ModernItemModel> modernItemModels1_21_4 = new HashMap<Key, ModernItemModel>();
    protected final Map<Key, TreeSet<LegacyOverridesModel>> modernItemModels1_21_2 = new HashMap<Key, TreeSet<LegacyOverridesModel>>();
    protected final Map<Key, TreeSet<LegacyOverridesModel>> legacyOverrides = new HashMap<Key, TreeSet<LegacyOverridesModel>>();
    protected final Map<Key, TreeMap<Integer, ModernItemModel>> modernOverrides = new HashMap<Key, TreeMap<Integer, ModernItemModel>>();
    protected final Map<Key, Equipment> equipments = new HashMap<Key, Equipment>();
    protected final List<Suggestion> cachedSuggestions = new ArrayList<Suggestion>();
    protected final List<Suggestion> cachedTotemSuggestions = new ArrayList<Suggestion>();

    protected AbstractItemManager(CraftEngine plugin) {
        super(plugin);
        this.itemParser = new ItemParser();
        this.equipmentParser = new EquipmentParser();
        ItemDataModifiers.init();
    }

    protected static void registerVanillaItemExtraBehavior(ItemBehavior behavior, Key ... items) {
        for (Key key : items) {
            VANILLA_ITEM_EXTRA_BEHAVIORS.computeIfAbsent(key, k -> new ArrayList()).add(behavior);
        }
    }

    protected void applyDataModifiers(Map<String, Object> dataSection, Consumer<ItemDataModifier<I>> callback) {
        ExceptionCollector errorCollector = new ExceptionCollector();
        if (dataSection != null) {
            for (Map.Entry<String, Object> dataEntry : dataSection.entrySet()) {
                Object value = dataEntry.getValue();
                if (value == null) continue;
                Optional.ofNullable(BuiltInRegistries.ITEM_DATA_MODIFIER_FACTORY.getValue(Key.withDefaultNamespace(dataEntry.getKey(), "craftengine"))).ifPresent(factory -> {
                    try {
                        callback.accept(factory.create(value));
                    }
                    catch (LocalizedResourceConfigException e) {
                        errorCollector.add(e);
                    }
                });
            }
        }
        errorCollector.throwIfPresent();
    }

    @Override
    public ConfigParser[] parsers() {
        return new ConfigParser[]{this.itemParser, this.equipmentParser};
    }

    @Override
    public ExternalItemSource<I> getExternalItemSource(String name) {
        return this.externalItemSources.get(name);
    }

    @Override
    public boolean registerExternalItemSource(ExternalItemSource<I> externalItemSource) {
        if (!ResourceLocation.isValidNamespace(externalItemSource.plugin())) {
            return false;
        }
        if (this.externalItemSources.containsKey(externalItemSource.plugin())) {
            return false;
        }
        this.externalItemSources.put(externalItemSource.plugin(), externalItemSource);
        return true;
    }

    @Override
    public void unload() {
        super.clearModelsToGenerate();
        this.customItems.clear();
        this.cachedSuggestions.clear();
        this.cachedTotemSuggestions.clear();
        this.legacyOverrides.clear();
        this.modernOverrides.clear();
        this.customItemTags.clear();
        this.equipments.clear();
        this.cmdConflictChecker.clear();
        this.modernItemModels1_21_4.clear();
        this.modernItemModels1_21_2.clear();
    }

    @Override
    public Map<Key, Equipment> equipments() {
        return Collections.unmodifiableMap(this.equipments);
    }

    @Override
    public Optional<Equipment> getEquipment(Key key) {
        return Optional.ofNullable(this.equipments.get(key));
    }

    @Override
    public Optional<CustomItem<I>> getCustomItem(Key key) {
        return Optional.ofNullable(this.customItems.get(key));
    }

    @Override
    public boolean addCustomItem(CustomItem<I> customItem) {
        Key id = customItem.id();
        if (this.customItems.containsKey(id)) {
            return false;
        }
        this.customItems.put(id, customItem);
        if (!customItem.isVanillaItem()) {
            this.cachedSuggestions.add(Suggestion.suggestion((String)id.toString()));
            if (VersionHelper.isOrAbove1_21_2()) {
                this.cachedTotemSuggestions.add(Suggestion.suggestion((String)id.toString()));
            } else if (customItem.material().equals(ItemKeys.TOTEM_OF_UNDYING)) {
                this.cachedTotemSuggestions.add(Suggestion.suggestion((String)id.toString()));
            }
            Set<Key> tags = customItem.settings().tags();
            for (Key tag : tags) {
                this.customItemTags.computeIfAbsent(tag, k -> new ArrayList()).add(customItem.uniqueId());
            }
        }
        return true;
    }

    @Override
    public List<UniqueKey> vanillaItemIdsByTag(Key tag) {
        return Collections.unmodifiableList(VANILLA_ITEM_TAGS.getOrDefault(tag, List.of()));
    }

    @Override
    public List<UniqueKey> customItemIdsByTag(Key tag) {
        return Collections.unmodifiableList(this.customItemTags.getOrDefault(tag, List.of()));
    }

    @Override
    public Collection<Suggestion> cachedSuggestions() {
        return Collections.unmodifiableCollection(this.cachedSuggestions);
    }

    @Override
    public Collection<Suggestion> cachedTotemSuggestions() {
        return Collections.unmodifiableCollection(this.cachedTotemSuggestions);
    }

    @Override
    public Optional<List<ItemBehavior>> getItemBehavior(Key key) {
        Optional<CustomItem<I>> customItemOptional = this.getCustomItem(key);
        if (customItemOptional.isPresent()) {
            CustomItem<I> customItem = customItemOptional.get();
            Key vanillaMaterial = customItem.material();
            List<ItemBehavior> behavior = VANILLA_ITEM_EXTRA_BEHAVIORS.get(vanillaMaterial);
            if (behavior != null) {
                return Optional.of(Stream.concat(customItem.behaviors().stream(), behavior.stream()).toList());
            }
            return Optional.of(List.copyOf(customItem.behaviors()));
        }
        List<ItemBehavior> behavior = VANILLA_ITEM_EXTRA_BEHAVIORS.get(key);
        if (behavior != null) {
            return Optional.of(List.copyOf(behavior));
        }
        return Optional.empty();
    }

    @Override
    public Collection<Key> items() {
        return Collections.unmodifiableCollection(this.customItems.keySet());
    }

    @Override
    public Map<Key, ModernItemModel> modernItemModels1_21_4() {
        return Collections.unmodifiableMap(this.modernItemModels1_21_4);
    }

    @Override
    public Map<Key, TreeSet<LegacyOverridesModel>> modernItemModels1_21_2() {
        return Collections.unmodifiableMap(this.modernItemModels1_21_2);
    }

    @Override
    public Collection<Key> vanillaItems() {
        return Collections.unmodifiableCollection(VANILLA_ITEMS);
    }

    @Override
    public Map<Key, TreeSet<LegacyOverridesModel>> legacyItemOverrides() {
        return Collections.unmodifiableMap(this.legacyOverrides);
    }

    @Override
    public Map<Key, TreeMap<Integer, ModernItemModel>> modernItemOverrides() {
        return Collections.unmodifiableMap(this.modernOverrides);
    }

    @Override
    public boolean isVanillaItem(Key item) {
        return VANILLA_ITEMS.contains(item);
    }

    protected abstract CustomItem.Builder<I> createPlatformItemBuilder(UniqueKey var1, Key var2, Key var3);

    protected abstract void registerArmorTrimPattern(Collection<Key> var1);

    public void addOrMergeEquipment(ComponentBasedEquipment equipment) {
        Equipment previous = this.equipments.get(equipment.assetId());
        if (previous instanceof ComponentBasedEquipment) {
            ComponentBasedEquipment another = (ComponentBasedEquipment)previous;
            for (Map.Entry<EquipmentLayerType, List<ComponentBasedEquipment.Layer>> entry : equipment.layers().entrySet()) {
                another.addLayer(entry.getKey(), entry.getValue());
            }
        } else {
            this.equipments.put(equipment.assetId(), equipment);
        }
    }

    protected void processModelRecursively(ItemModel currentModel, Map<String, Object> accumulatedPredicates, Collection<LegacyOverridesModel> resultList, Key materialId, int customModelData) {
        if (currentModel instanceof ConditionItemModel) {
            ConditionItemModel conditionModel = (ConditionItemModel)currentModel;
            this.handleConditionModel(conditionModel, accumulatedPredicates, resultList, materialId, customModelData);
        } else if (currentModel instanceof RangeDispatchItemModel) {
            RangeDispatchItemModel rangeModel = (RangeDispatchItemModel)currentModel;
            this.handleRangeModel(rangeModel, accumulatedPredicates, resultList, materialId, customModelData);
        } else if (currentModel instanceof SelectItemModel) {
            SelectItemModel selectModel = (SelectItemModel)currentModel;
            this.handleSelectModel(selectModel, accumulatedPredicates, resultList, materialId, customModelData);
        } else if (currentModel instanceof BaseItemModel) {
            BaseItemModel baseModel = (BaseItemModel)currentModel;
            resultList.add(new LegacyOverridesModel(new LinkedHashMap<String, Object>(accumulatedPredicates), baseModel.path(), customModelData));
        } else if (currentModel instanceof SpecialItemModel) {
            SpecialItemModel specialModel = (SpecialItemModel)currentModel;
            resultList.add(new LegacyOverridesModel(new LinkedHashMap<String, Object>(accumulatedPredicates), specialModel.base(), customModelData));
        }
    }

    private void handleConditionModel(ConditionItemModel model, Map<String, Object> parentPredicates, Collection<LegacyOverridesModel> resultList, Key materialId, int customModelData) {
        ConditionProperty conditionProperty = model.property();
        if (conditionProperty instanceof LegacyModelPredicate) {
            LegacyModelPredicate predicate = (LegacyModelPredicate)((Object)conditionProperty);
            String predicateId = predicate.legacyPredicateId(materialId);
            Map<String, Object> truePredicates = this.mergePredicates(parentPredicates, predicateId, predicate.toLegacyValue(true));
            this.processModelRecursively(model.onTrue(), truePredicates, resultList, materialId, customModelData);
            Map<String, Object> falsePredicates = this.mergePredicates(parentPredicates, predicateId, predicate.toLegacyValue(false));
            this.processModelRecursively(model.onFalse(), falsePredicates, resultList, materialId, customModelData);
        }
    }

    private void handleRangeModel(RangeDispatchItemModel model, Map<String, Object> parentPredicates, Collection<LegacyOverridesModel> resultList, Key materialId, int customModelData) {
        RangeDispatchProperty rangeDispatchProperty = model.property();
        if (rangeDispatchProperty instanceof LegacyModelPredicate) {
            LegacyModelPredicate predicate = (LegacyModelPredicate)((Object)rangeDispatchProperty);
            String predicateId = predicate.legacyPredicateId(materialId);
            for (Map.Entry<Float, ItemModel> entry : model.entries().entrySet()) {
                Map<String, Object> merged = this.mergePredicates(parentPredicates, predicateId, predicate.toLegacyValue(entry.getKey()));
                this.processModelRecursively(entry.getValue(), merged, resultList, materialId, customModelData);
            }
            if (model.fallBack() != null) {
                Map<String, Object> merged = this.mergePredicates(parentPredicates, predicateId, predicate.toLegacyValue(Float.valueOf(0.0f)));
                this.processModelRecursively(model.fallBack(), merged, resultList, materialId, customModelData);
            }
        }
    }

    private void handleSelectModel(SelectItemModel model, Map<String, Object> parentPredicates, Collection<LegacyOverridesModel> resultList, Key materialId, int customModelData) {
        SelectProperty selectProperty = model.property();
        if (selectProperty instanceof LegacyModelPredicate) {
            LegacyModelPredicate predicate = (LegacyModelPredicate)((Object)selectProperty);
            String predicateId = predicate.legacyPredicateId(materialId);
            for (Map.Entry<Either<JsonElement, List<JsonElement>>, ItemModel> entry : model.whenMap().entrySet()) {
                List cases = (List)entry.getKey().fallbackOrMapPrimary(List::of);
                for (JsonElement caseValue : cases) {
                    if (!(caseValue instanceof JsonPrimitive)) continue;
                    JsonPrimitive primitive = (JsonPrimitive)caseValue;
                    Number legacyValue = primitive.isBoolean() ? (Number)predicate.toLegacyValue(primitive.getAsBoolean()) : (Number)(primitive.isString() ? (Number)predicate.toLegacyValue(primitive.getAsString()) : (Number)predicate.toLegacyValue(primitive.getAsNumber()));
                    if (predicate instanceof TrimMaterialSelectProperty && legacyValue.floatValue() > 1.0f) continue;
                    Map<String, Object> merged = this.mergePredicates(parentPredicates, predicateId, legacyValue);
                    if (predicate instanceof ChargeTypeSelectProperty && materialId.equals(ItemKeys.CROSSBOW)) {
                        merged = this.mergePredicates(merged, "charged", 1);
                    }
                    this.processModelRecursively(entry.getValue(), merged, resultList, materialId, customModelData);
                }
            }
            if (model.fallBack() != null) {
                if (predicate instanceof ChargeTypeSelectProperty && materialId.equals(ItemKeys.CROSSBOW)) {
                    this.processModelRecursively(model.fallBack(), this.mergePredicates(parentPredicates, "charged", 0), resultList, materialId, customModelData);
                } else if (predicate instanceof TrimMaterialSelectProperty) {
                    this.processModelRecursively(model.fallBack(), this.mergePredicates(parentPredicates, "trim_type", Float.valueOf(0.0f)), resultList, materialId, customModelData);
                }
            }
        }
    }

    private Map<String, Object> mergePredicates(Map<String, Object> existing, String newKey, Number newValue) {
        LinkedHashMap<String, Object> merged = new LinkedHashMap<String, Object>(existing);
        if (newKey == null) {
            return merged;
        }
        merged.put(newKey, newValue);
        return merged;
    }

    public class ItemParser
    implements ConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"items", "item"};

        private boolean isModernFormatRequired() {
            return Config.packMaxVersion().isAtOrAbove(MinecraftVersions.V1_21_4);
        }

        private boolean needsLegacyCompatibility() {
            return Config.packMinVersion().isBelow(MinecraftVersions.V1_21_4);
        }

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 60;
        }

        @Override
        public void parseSection(Pack pack, Path path, Key id, Map<String, Object> section) {
            boolean needsModelSection;
            List<ItemBehavior> behaviors;
            ItemSettings settings;
            Map<EventTrigger, List<Function<PlayerOptionalContext>>> eventTriggerListMap;
            boolean clientBoundModel;
            if (AbstractItemManager.this.customItems.containsKey(id)) {
                throw new LocalizedResourceConfigException("warning.config.item.duplicate", new String[0]);
            }
            UniqueKey uniqueId = UniqueKey.create(id);
            boolean isVanillaItem = AbstractItemManager.this.isVanillaItem(id);
            Key material = Key.from(isVanillaItem ? id.value() : ResourceConfigUtils.requireNonEmptyStringOrThrow(section.get("material"), "warning.config.item.missing_material").toLowerCase(Locale.ENGLISH));
            Key clientBoundMaterial = section.containsKey("client-bound-material") ? Key.from(section.get("client-bound-material").toString().toLowerCase(Locale.ENGLISH)) : material;
            int customModelData = isVanillaItem ? 0 : ResourceConfigUtils.getAsInt(section.getOrDefault("custom-model-data", 0), "custom-model-data");
            boolean bl = clientBoundModel = section.containsKey("client-bound-model") ? ResourceConfigUtils.getAsBoolean(section.get("client-bound-data"), "client-bound-data") : Config.globalClientboundModel();
            if (customModelData < 0) {
                throw new LocalizedResourceConfigException("warning.config.item.invalid_custom_model_data", String.valueOf(customModelData));
            }
            if (customModelData > 0x1000000) {
                throw new LocalizedResourceConfigException("warning.config.item.bad_custom_model_data", String.valueOf(customModelData));
            }
            Key itemModelKey = null;
            CustomItem.Builder itemBuilder = AbstractItemManager.this.createPlatformItemBuilder(uniqueId, material, clientBoundMaterial);
            boolean hasItemModelSection = section.containsKey("item-model");
            if (customModelData > 0) {
                if (clientBoundModel) {
                    itemBuilder.clientBoundDataModifier(new CustomModelDataModifier(customModelData));
                } else {
                    itemBuilder.dataModifier(new CustomModelDataModifier(customModelData));
                }
            } else if (!hasItemModelSection && section.containsKey("model") && VersionHelper.isOrAbove1_21_2()) {
                itemModelKey = Key.from(section.getOrDefault("item-model", id.toString()).toString());
                if (ResourceLocation.isValid(itemModelKey.toString())) {
                    if (clientBoundModel) {
                        itemBuilder.clientBoundDataModifier(new ItemModelModifier(itemModelKey));
                    } else {
                        itemBuilder.dataModifier(new ItemModelModifier(itemModelKey));
                    }
                } else {
                    itemModelKey = null;
                }
            }
            if (hasItemModelSection && VersionHelper.isOrAbove1_21_2()) {
                itemModelKey = Key.from(section.get("item-model").toString());
                if (clientBoundModel) {
                    itemBuilder.clientBoundDataModifier(new ItemModelModifier(itemModelKey));
                } else {
                    itemBuilder.dataModifier(new ItemModelModifier(itemModelKey));
                }
            }
            ExceptionCollector<LocalizedResourceConfigException> collector = new ExceptionCollector<LocalizedResourceConfigException>();
            try {
                AbstractItemManager.this.applyDataModifiers(MiscUtils.castToMap(section.get("data"), true), itemBuilder::dataModifier);
            }
            catch (LocalizedResourceConfigException e) {
                collector.add(e);
            }
            try {
                AbstractItemManager.this.applyDataModifiers(MiscUtils.castToMap(section.get("client-bound-data"), true), itemBuilder::clientBoundDataModifier);
            }
            catch (LocalizedResourceConfigException e) {
                collector.add(e);
            }
            if (!isVanillaItem) {
                itemBuilder.dataModifier(new IdModifier(id));
            }
            try {
                eventTriggerListMap = EventFunctions.parseEvents(ResourceConfigUtils.get(section, "events", "event"));
            }
            catch (LocalizedResourceConfigException e) {
                collector.add(e);
                eventTriggerListMap = Map.of();
            }
            try {
                settings = Optional.ofNullable(ResourceConfigUtils.get(section, "settings")).map(map -> ItemSettings.fromMap(MiscUtils.castToMap(map, true))).map(it -> isVanillaItem ? it.canPlaceRelatedVanillaBlock(true) : it).orElse(ItemSettings.of().canPlaceRelatedVanillaBlock(isVanillaItem));
            }
            catch (LocalizedResourceConfigException e) {
                collector.add(e);
                settings = ItemSettings.of().canPlaceRelatedVanillaBlock(isVanillaItem);
            }
            try {
                behaviors = ItemBehaviors.fromObj(pack, path, id, ResourceConfigUtils.get(section, "behavior", "behaviors"));
            }
            catch (LocalizedResourceConfigException e) {
                collector.add(e);
                behaviors = Collections.emptyList();
            }
            CustomItem customItem = itemBuilder.isVanillaItem(isVanillaItem).behaviors(behaviors).settings(settings).events(eventTriggerListMap).build();
            AbstractItemManager.this.addCustomItem(customItem);
            if (section.containsKey("category")) {
                AbstractItemManager.this.plugin.itemBrowserManager().addExternalCategoryMember(id, MiscUtils.getAsStringList(section.get("category")).stream().map(Key::of).toList());
            }
            Map<String, Object> modelSection = MiscUtils.castToMap(section.get("model"), true);
            Map<String, Object> legacyModelSection = MiscUtils.castToMap(section.get("legacy-model"), true);
            if (modelSection == null && legacyModelSection == null) {
                collector.throwIfPresent();
                return;
            }
            boolean bl2 = needsModelSection = this.isModernFormatRequired() || this.needsLegacyCompatibility() && legacyModelSection == null;
            if (!isVanillaItem && customModelData == 0 && itemModelKey == null) {
                collector.addAndThrow(new LocalizedResourceConfigException("warning.config.item.missing_model_id", new String[0]));
            }
            ItemModel modernModel = null;
            TreeSet<LegacyOverridesModel> legacyOverridesModels = null;
            if (needsModelSection) {
                if (modelSection == null) {
                    collector.addAndThrow(new LocalizedResourceConfigException("warning.config.item.missing_model", new String[0]));
                    return;
                }
                try {
                    modernModel = ItemModels.fromMap(modelSection);
                    for (ModelGeneration modelGeneration : modernModel.modelsToGenerate()) {
                        AbstractItemManager.this.prepareModelGeneration(modelGeneration);
                    }
                }
                catch (LocalizedResourceConfigException e) {
                    collector.addAndThrow(e);
                }
            }
            if (this.needsLegacyCompatibility()) {
                if (legacyModelSection != null) {
                    try {
                        LegacyItemModel legacyItemModel = LegacyItemModel.fromMap(legacyModelSection, customModelData);
                        for (ModelGeneration generation : legacyItemModel.modelsToGenerate()) {
                            AbstractItemManager.this.prepareModelGeneration(generation);
                        }
                        legacyOverridesModels = new TreeSet<LegacyOverridesModel>(legacyItemModel.overrides());
                    }
                    catch (LocalizedResourceConfigException e) {
                        collector.addAndThrow(e);
                    }
                } else {
                    legacyOverridesModels = new TreeSet<LegacyOverridesModel>();
                    AbstractItemManager.this.processModelRecursively(modernModel, new LinkedHashMap<String, Object>(), legacyOverridesModels, clientBoundMaterial, customModelData);
                    if (legacyOverridesModels.isEmpty()) {
                        collector.add(new LocalizedResourceConfigException("warning.config.item.legacy_model.cannot_convert", path.toString(), id.asString()));
                    }
                }
            }
            if (!isVanillaItem) {
                boolean isVanillaItemModel;
                boolean bl3 = isVanillaItemModel = itemModelKey != null && AbstractPackManager.PRESET_ITEMS.containsKey(itemModelKey);
                if (customModelData != 0) {
                    Key key = isVanillaItemModel ? itemModelKey : clientBoundMaterial;
                    Map conflict = AbstractItemManager.this.cmdConflictChecker.computeIfAbsent(key, k -> new HashMap());
                    if (conflict.containsKey(customModelData)) {
                        collector.addAndThrow(new LocalizedResourceConfigException("warning.config.item.custom_model_data_conflict", String.valueOf(customModelData), ((Key)conflict.get(customModelData)).toString()));
                    }
                    conflict.put(customModelData, id);
                    if (this.isModernFormatRequired() && modernModel != null) {
                        TreeMap map2 = AbstractItemManager.this.modernOverrides.computeIfAbsent(key, k -> new TreeMap());
                        map2.put(customModelData, new ModernItemModel(modernModel, ResourceConfigUtils.getAsBoolean(section.getOrDefault("oversized-in-gui", true), "oversized-in-gui"), ResourceConfigUtils.getAsBoolean(section.getOrDefault("hand-animation-on-swap", true), "hand-animation-on-swap")));
                    }
                    if (this.needsLegacyCompatibility() && legacyOverridesModels != null && !legacyOverridesModels.isEmpty()) {
                        TreeSet lom = AbstractItemManager.this.legacyOverrides.computeIfAbsent(key, k -> new TreeSet());
                        lom.addAll(legacyOverridesModels);
                    }
                } else if (isVanillaItemModel) {
                    collector.addAndThrow(new LocalizedResourceConfigException("warning.config.item.item_model.conflict", itemModelKey.asString()));
                }
                if (itemModelKey != null && !isVanillaItemModel) {
                    if (this.isModernFormatRequired() && modernModel != null) {
                        AbstractItemManager.this.modernItemModels1_21_4.put(itemModelKey, new ModernItemModel(modernModel, ResourceConfigUtils.getAsBoolean(section.getOrDefault("oversized-in-gui", true), "oversized-in-gui"), ResourceConfigUtils.getAsBoolean(section.getOrDefault("hand-animation-on-swap", true), "hand-animation-on-swap")));
                    }
                    if (Config.packMaxVersion().isAtOrAbove(MinecraftVersions.V1_21_2) && this.needsLegacyCompatibility() && legacyOverridesModels != null && !legacyOverridesModels.isEmpty()) {
                        TreeSet treeSet = AbstractItemManager.this.modernItemModels1_21_2.computeIfAbsent(itemModelKey, k -> new TreeSet());
                        treeSet.addAll(legacyOverridesModels);
                    }
                }
            } else if (this.isModernFormatRequired()) {
                AbstractItemManager.this.modernItemModels1_21_4.put(id, new ModernItemModel(modernModel, ResourceConfigUtils.getAsBoolean(section.getOrDefault("oversized-in-gui", true), "oversized-in-gui"), ResourceConfigUtils.getAsBoolean(section.getOrDefault("hand-animation-on-swap", true), "hand-animation-on-swap")));
            }
            collector.throwIfPresent();
        }
    }

    public class EquipmentParser
    implements ConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"equipments", "equipment"};

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 50;
        }

        @Override
        public void parseSection(Pack pack, Path path, Key id, Map<String, Object> section) {
            if (AbstractItemManager.this.equipments.containsKey(id)) {
                throw new LocalizedResourceConfigException("warning.config.equipment.duplicate", new String[0]);
            }
            Equipment equipment = Equipments.fromMap(id, section);
            AbstractItemManager.this.equipments.put(id, equipment);
        }

        @Override
        public void postProcess() {
            List<Key> trims = AbstractItemManager.this.equipments.values().stream().filter(TrimBasedEquipment.class::isInstance).map(Equipment::assetId).toList();
            AbstractItemManager.this.registerArmorTrimPattern(trims);
        }
    }
}

