/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.modifier.lore;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.TriFunction;
import net.momirealms.craftengine.libraries.adventure.text.Component;

public record LoreModification(Operation operation, boolean split, String[] content) {
    public Stream<Component> apply(Stream<Component> lore, ItemBuildContext context) {
        return this.operation.function.apply(lore, context, this);
    }

    public Stream<Component> parseAsStream(ItemBuildContext context) {
        Stream<Component> parsed = Arrays.stream(this.content).map(string -> AdventureHelper.miniMessage().deserialize(string, context.tagResolvers()));
        return this.split ? parsed.map(AdventureHelper::splitLines).flatMap(Collection::stream) : parsed;
    }

    public List<Component> parseAsList(ItemBuildContext context) {
        return this.parseAsStream(context).collect(Collectors.toList());
    }

    public static enum Operation {
        APPEND((s, c, modification) -> Stream.concat(s, modification.parseAsStream((ItemBuildContext)c))),
        PREPEND((s, c, modification) -> Stream.concat(modification.parseAsStream((ItemBuildContext)c), s));

        private final TriFunction<Stream<Component>, ItemBuildContext, LoreModification, Stream<Component>> function;

        private Operation(TriFunction<Stream<Component>, ItemBuildContext, LoreModification, Stream<Component>> function) {
            this.function = function;
        }
    }
}

