/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.item.recipe.AbstractRecipeSerializer;
import net.momirealms.craftengine.core.item.recipe.AbstractedFixedResultRecipe;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.RecipeSerializers;
import net.momirealms.craftengine.core.item.recipe.RecipeType;
import net.momirealms.craftengine.core.item.recipe.input.BrewingInput;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import net.momirealms.craftengine.core.item.recipe.result.CustomRecipeResult;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import org.jetbrains.annotations.NotNull;

public class CustomBrewingRecipe<T>
extends AbstractedFixedResultRecipe<T> {
    public static final Serializer<?> SERIALIZER = new Serializer();
    private final Ingredient<T> container;
    private final Ingredient<T> ingredient;

    public CustomBrewingRecipe(@NotNull Key id, @NotNull Ingredient<T> container, @NotNull Ingredient<T> ingredient, @NotNull CustomRecipeResult<T> result, boolean showNotification) {
        super(id, showNotification, result);
        this.container = container;
        this.ingredient = ingredient;
        this.result = result;
    }

    @Override
    public boolean matches(RecipeInput input) {
        BrewingInput brewingInput = (BrewingInput)input;
        return this.container.test(brewingInput.container()) && this.ingredient.test(brewingInput.ingredient());
    }

    @Override
    public List<Ingredient<T>> ingredientsInUse() {
        ArrayList<Ingredient<T>> ingredients = new ArrayList<Ingredient<T>>();
        ingredients.add(this.container);
        ingredients.add(this.ingredient);
        return ingredients;
    }

    @Override
    @NotNull
    public Key serializerType() {
        return RecipeSerializers.BREWING;
    }

    @Override
    public RecipeType type() {
        return RecipeType.BREWING;
    }

    @NotNull
    public Ingredient<T> container() {
        return this.container;
    }

    @NotNull
    public Ingredient<T> ingredient() {
        return this.ingredient;
    }

    public static class Serializer<A>
    extends AbstractRecipeSerializer<A, CustomBrewingRecipe<A>> {
        @Override
        public CustomBrewingRecipe<A> readMap(Key id, Map<String, Object> arguments) {
            List<String> container = MiscUtils.getAsStringList(arguments.get("container"));
            if (container.isEmpty()) {
                throw new LocalizedResourceConfigException("warning.config.recipe.brewing.missing_container", new String[0]);
            }
            List<String> ingredient = MiscUtils.getAsStringList(arguments.get("ingredient"));
            if (ingredient.isEmpty()) {
                throw new LocalizedResourceConfigException("warning.config.recipe.brewing.missing_ingredient", new String[0]);
            }
            return new CustomBrewingRecipe(id, ResourceConfigUtils.requireNonNullOrThrow(this.toIngredient(container), "warning.config.recipe.brewing.missing_container"), ResourceConfigUtils.requireNonNullOrThrow(this.toIngredient(ingredient), "warning.config.recipe.brewing.missing_ingredient"), this.parseResult(arguments), this.showNotification(arguments));
        }

        @Override
        public CustomBrewingRecipe<A> readJson(Key id, JsonObject json) {
            throw new UnsupportedOperationException();
        }
    }
}

