/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import java.util.List;
import net.momirealms.craftengine.core.item.recipe.AbstractGroupedRecipe;
import net.momirealms.craftengine.core.item.recipe.CookingRecipeCategory;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import net.momirealms.craftengine.core.item.recipe.input.SingleItemInput;
import net.momirealms.craftengine.core.item.recipe.result.CustomRecipeResult;
import net.momirealms.craftengine.core.util.Key;

public abstract class CustomCookingRecipe<T>
extends AbstractGroupedRecipe<T> {
    protected final CookingRecipeCategory category;
    protected final Ingredient<T> ingredient;
    protected final float experience;
    protected final int cookingTime;

    protected CustomCookingRecipe(Key id, boolean showNotification, CustomRecipeResult<T> result, String group, CookingRecipeCategory category, Ingredient<T> ingredient, int cookingTime, float experience) {
        super(id, showNotification, result, group);
        this.category = category == null ? CookingRecipeCategory.MISC : category;
        this.ingredient = ingredient;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    @Override
    public boolean matches(RecipeInput input) {
        return this.ingredient.test(((SingleItemInput)input).input());
    }

    public CookingRecipeCategory category() {
        return this.category;
    }

    public Ingredient<T> ingredient() {
        return this.ingredient;
    }

    public float experience() {
        return this.experience;
    }

    public int cookingTime() {
        return this.cookingTime;
    }

    @Override
    public List<Ingredient<T>> ingredientsInUse() {
        return List.of(this.ingredient);
    }
}

