/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import net.momirealms.craftengine.core.item.recipe.StackedContents;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.util.UniqueKey;

public class Ingredient<T>
implements Predicate<UniqueIdItem<T>>,
StackedContents.IngredientInfo<UniqueKey> {
    private final List<UniqueKey> items;
    private final List<UniqueKey> vanillaItems;
    private final boolean hasCustomItem;

    private Ingredient(List<UniqueKey> items, List<UniqueKey> vanillaItems, boolean hasCustomItem) {
        this.items = List.copyOf(items);
        this.vanillaItems = List.copyOf(vanillaItems);
        this.hasCustomItem = hasCustomItem;
    }

    public static <T> boolean isInstance(Optional<Ingredient<T>> optionalIngredient, UniqueIdItem<T> stack) {
        return optionalIngredient.map(ingredient -> ingredient.test(stack)).orElseGet(stack::isEmpty);
    }

    public static <T> Ingredient<T> of(Set<UniqueKey> items, Set<UniqueKey> minecraftItems, boolean hasCustomItem) {
        return new Ingredient<T>(new ArrayList<UniqueKey>(items), new ArrayList<UniqueKey>(minecraftItems), hasCustomItem);
    }

    public boolean hasCustomItem() {
        return this.hasCustomItem;
    }

    @Override
    public boolean test(UniqueIdItem<T> uniqueIdItem) {
        for (UniqueKey item : this.items()) {
            if (!uniqueIdItem.is(item)) continue;
            return true;
        }
        return false;
    }

    public List<UniqueKey> items() {
        return this.items;
    }

    public List<UniqueKey> minecraftItems() {
        return this.vanillaItems;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ");
        for (UniqueKey item : this.items()) {
            joiner.add(item.toString());
        }
        return "Ingredient: [" + String.valueOf(joiner) + "]";
    }

    public boolean isEmpty() {
        return this.items().isEmpty();
    }

    @Override
    public boolean acceptsItem(UniqueKey entry) {
        return this.items.contains(entry);
    }
}

