/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe.reader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.momirealms.craftengine.core.item.recipe.CookingRecipeCategory;
import net.momirealms.craftengine.core.item.recipe.CraftingRecipeCategory;
import net.momirealms.craftengine.core.item.recipe.DatapackRecipeResult;
import net.momirealms.craftengine.core.item.recipe.reader.VanillaRecipeReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaRecipeReader1_20
implements VanillaRecipeReader {
    @Override
    @NotNull
    public DatapackRecipeResult cookingResult(JsonElement object) {
        return new DatapackRecipeResult(object.getAsString(), 1, null);
    }

    @Override
    @NotNull
    public DatapackRecipeResult craftingResult(JsonObject object) {
        String item = object.get("item").getAsString();
        int count = object.has("count") ? object.get("count").getAsInt() : 1;
        return new DatapackRecipeResult(item, count, null);
    }

    @Override
    @NotNull
    public DatapackRecipeResult smithingResult(JsonObject object) {
        String item = object.get("item").getAsString();
        return new DatapackRecipeResult(item, 1, null);
    }

    @Override
    public List<List<String>> shapelessIngredients(JsonArray json) {
        ArrayList<List<String>> ingredients = new ArrayList<List<String>>();
        for (JsonElement element : json) {
            if (element.isJsonObject()) {
                JsonObject jsonObject = element.getAsJsonObject();
                if (jsonObject.has("item")) {
                    ingredients.add(List.of(jsonObject.get("item").getAsString()));
                    continue;
                }
                if (!jsonObject.has("tag")) continue;
                ingredients.add(List.of("#" + jsonObject.get("tag").getAsString()));
                continue;
            }
            if (!element.isJsonArray()) continue;
            List<String> ingredient = this.ingredientList((JsonArray)element);
            ingredients.add(ingredient);
        }
        return ingredients;
    }

    @Override
    public Map<Character, List<String>> shapedIngredientMap(JsonObject json) {
        HashMap<Character, List<String>> ingredients = new HashMap<Character, List<String>>();
        for (Map.Entry entry : json.entrySet()) {
            char c = ((String)entry.getKey()).charAt(0);
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                JsonObject argument = ((JsonElement)entry.getValue()).getAsJsonObject();
                if (argument.has("item")) {
                    ingredients.put(Character.valueOf(c), List.of(argument.get("item").getAsString()));
                    continue;
                }
                if (!argument.has("tag")) continue;
                ingredients.put(Character.valueOf(c), List.of("#" + argument.get("tag").getAsString()));
                continue;
            }
            if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
            List<String> items = this.ingredientList((JsonArray)entry.getValue());
            ingredients.put(Character.valueOf(c), items);
        }
        return ingredients;
    }

    @Override
    @NotNull
    public List<String> ingredientList(JsonArray array) {
        ArrayList<String> items = new ArrayList<String>();
        for (JsonElement element : array) {
            if (!element.isJsonObject()) continue;
            JsonObject argument = element.getAsJsonObject();
            if (argument.has("item")) {
                items.add(argument.get("item").getAsString());
                continue;
            }
            if (!argument.has("tag")) continue;
            items.add("#" + argument.get("tag").getAsString());
        }
        return items;
    }

    @Override
    public String[] craftingShapedPattern(JsonObject object) {
        JsonArray pattern = object.getAsJsonArray("pattern");
        ArrayList<String> patternList = new ArrayList<String>();
        for (JsonElement element : pattern) {
            patternList.add(element.getAsString());
        }
        return patternList.toArray(new String[0]);
    }

    @Override
    @Nullable
    public String readGroup(JsonObject object) {
        return object.has("group") ? object.get("group").getAsString() : null;
    }

    @Override
    @NotNull
    public CraftingRecipeCategory craftingCategory(JsonObject object) {
        return object.has("category") ? CraftingRecipeCategory.valueOf(object.get("category").getAsString().toUpperCase(Locale.ENGLISH)) : CraftingRecipeCategory.MISC;
    }

    @Override
    @NotNull
    public CookingRecipeCategory cookingCategory(JsonObject object) {
        return object.has("category") ? CookingRecipeCategory.valueOf(object.get("category").getAsString().toUpperCase(Locale.ENGLISH)) : CookingRecipeCategory.MISC;
    }

    @Override
    public float cookingExperience(JsonObject object) {
        return object.has("experience") ? object.get("experience").getAsFloat() : 0.0f;
    }

    @Override
    public int cookingTime(JsonObject object) {
        return object.has("cookingtime") ? object.get("cookingtime").getAsInt() : 200;
    }

    @Override
    @NotNull
    public DatapackRecipeResult stoneCuttingResult(JsonObject json) {
        int count = json.has("count") ? json.get("count").getAsInt() : 1;
        String result = json.get("result").getAsString();
        return new DatapackRecipeResult(result, count, null);
    }

    @Override
    public List<String> singleIngredient(JsonElement json) {
        ArrayList<String> ingredients = new ArrayList<String>();
        if (json.isJsonObject()) {
            JsonObject argument = json.getAsJsonObject();
            if (argument.has("item")) {
                ingredients.add(argument.get("item").getAsString());
            } else if (argument.has("tag")) {
                ingredients.add("#" + argument.get("tag").getAsString());
            }
        } else if (json.isJsonArray()) {
            List<String> items = this.ingredientList((JsonArray)json);
            ingredients.addAll(items);
        }
        return ingredients;
    }

    @Override
    public boolean showNotification(JsonObject json) {
        return !json.has("show_notification") || json.get("show_notification").getAsBoolean();
    }
}

