/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe.result;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.item.recipe.result.ApplyItemDataPostProcessor;
import net.momirealms.craftengine.core.item.recipe.result.PostProcessor;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class PostProcessors {
    public static final Key APPLY_DATA = Key.of("craftengine:apply_data");

    public static <T> PostProcessor<T> fromMap(Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.recipe.result.post_processor.missing_type");
        Key key = Key.withDefaultNamespace(type, "craftengine");
        PostProcessor.Type<?> processor = BuiltInRegistries.RECIPE_POST_PROCESSOR_TYPE.getValue(key);
        if (processor == null) {
            throw new LocalizedResourceConfigException("warning.config.recipe.result.post_processor.invalid_type", type);
        }
        return processor.create(map);
    }

    public static void registerPostProcessorType(Key id, PostProcessor.Type<?> type) {
        ((WritableRegistry)BuiltInRegistries.RECIPE_POST_PROCESSOR_TYPE).register(ResourceKey.create(Registries.RECIPE_POST_PROCESSOR_TYPE.location(), id), type);
    }

    static {
        PostProcessors.registerPostProcessorType(APPLY_DATA, args -> {
            ArrayList modifiers = new ArrayList();
            Map<String, Object> data = ResourceConfigUtils.getAsMap(args.get("data"), "data");
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                Optional.ofNullable(BuiltInRegistries.ITEM_DATA_MODIFIER_FACTORY.getValue(Key.withDefaultNamespace(entry.getKey(), "craftengine"))).ifPresent(factory -> modifiers.add(factory.create(entry.getValue())));
            }
            return new ApplyItemDataPostProcessor(modifiers.toArray(new ItemDataModifier[0]));
        });
    }
}

