/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.loot.function;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.data.Enchantment;
import net.momirealms.craftengine.core.loot.LootConditions;
import net.momirealms.craftengine.core.loot.LootContext;
import net.momirealms.craftengine.core.loot.function.AbstractLootConditionalFunction;
import net.momirealms.craftengine.core.loot.function.LootFunction;
import net.momirealms.craftengine.core.loot.function.LootFunctionFactory;
import net.momirealms.craftengine.core.loot.function.LootFunctions;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.RandomUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class ApplyBonusCountFunction<T>
extends AbstractLootConditionalFunction<T> {
    public static final Factory<?> FACTORY = new Factory();
    private final Key enchantment;
    private final Formula formula;

    public ApplyBonusCountFunction(List<Condition<LootContext>> predicates, Key enchantment, Formula formula) {
        super(predicates);
        this.enchantment = enchantment;
        this.formula = formula;
    }

    @Override
    protected Item<T> applyInternal(Item<T> item, LootContext context) {
        Optional<Item<?>> itemInHand = context.getOptionalParameter(DirectContextParameters.ITEM_IN_HAND);
        int level = itemInHand.map(value -> value.getEnchantment(this.enchantment).map(Enchantment::level).orElse(0)).orElse(0);
        int newCount = this.formula.apply(item.count(), level);
        item.count(newCount);
        return item;
    }

    @Override
    public Key type() {
        return LootFunctions.APPLY_BONUS;
    }

    public static interface Formula {
        public int apply(int var1, int var2);

        public Key type();
    }

    public static class Factory<T>
    implements LootFunctionFactory<T> {
        @Override
        public LootFunction<T> create(Map<String, Object> arguments) {
            String enchantment = ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.get("enchantment"), "warning.config.loot_table.function.apply_bonus.missing_enchantment");
            Map<String, Object> formulaMap = MiscUtils.castToMap(arguments.get("formula"), true);
            if (formulaMap == null) {
                throw new LocalizedResourceConfigException("warning.config.loot_table.function.apply_bonus.missing_formula", new String[0]);
            }
            List<Condition<LootContext>> conditions = Optional.ofNullable(arguments.get("conditions")).map(it -> LootConditions.fromMapList((List)it)).orElse(Collections.emptyList());
            return new ApplyBonusCountFunction(conditions, Key.from(enchantment), Formulas.fromMap(formulaMap));
        }
    }

    public static class CropDrops
    implements Formula {
        public static final Factory FACTORY = new Factory();
        private final int extra;
        private final float probability;

        public CropDrops(int extra, float probability) {
            this.extra = extra;
            this.probability = probability;
        }

        @Override
        public int apply(int initialCount, int enchantmentLevel) {
            for (int i = 0; i < enchantmentLevel + this.extra; ++i) {
                if (!(RandomUtils.generateRandomFloat(0.0f, 1.0f) < this.probability)) continue;
                ++initialCount;
            }
            return initialCount;
        }

        @Override
        public Key type() {
            return Formulas.CROP_DROPS;
        }

        public static class Factory
        implements FormulaFactory {
            @Override
            public Formula create(Map<String, Object> arguments) {
                int extra = ResourceConfigUtils.getAsInt(arguments.getOrDefault("extra", 1), "extra");
                float probability = ResourceConfigUtils.getAsFloat(arguments.getOrDefault("probability", Float.valueOf(0.5f)), "probability");
                return new CropDrops(extra, probability);
            }
        }
    }

    public static class OreDrops
    implements Formula {
        public static final Factory FACTORY = new Factory();
        private static final OreDrops INSTANCE = new OreDrops();

        @Override
        public int apply(int initialCount, int enchantmentLevel) {
            if (enchantmentLevel > 0) {
                int i = RandomUtils.generateRandomInt(0, enchantmentLevel + 2) - 1;
                if (i < 0) {
                    i = 0;
                }
                return initialCount * (i + 1);
            }
            return initialCount;
        }

        @Override
        public Key type() {
            return Formulas.ORE_DROPS;
        }

        public static class Factory
        implements FormulaFactory {
            @Override
            public Formula create(Map<String, Object> arguments) {
                return INSTANCE;
            }
        }
    }

    public static class Formulas {
        public static final Key ORE_DROPS = Key.of("craftengine:ore_drops");
        public static final Key CROP_DROPS = Key.of("craftengine:binomial_with_bonus_count");

        public static void register(Key key, FormulaFactory factory) {
            ((WritableRegistry)BuiltInRegistries.FORMULA_FACTORY).register(ResourceKey.create(Registries.FORMULA_FACTORY.location(), key), factory);
        }

        public static Formula fromMap(Map<String, Object> map) {
            String type = (String)map.get("type");
            if (type == null) {
                throw new NullPointerException("number type cannot be null");
            }
            Key key = Key.withDefaultNamespace(type, "craftengine");
            FormulaFactory factory = BuiltInRegistries.FORMULA_FACTORY.getValue(key);
            if (factory == null) {
                throw new IllegalArgumentException("Unknown formula type: " + type);
            }
            return factory.create(map);
        }

        static {
            Formulas.register(ORE_DROPS, OreDrops.FACTORY);
            Formulas.register(CROP_DROPS, CropDrops.FACTORY);
        }
    }

    public static interface FormulaFactory {
        public Formula create(Map<String, Object> var1);
    }
}

