/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.host;

import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.util.Map;
import net.momirealms.craftengine.core.pack.host.ResourcePackHost;
import net.momirealms.craftengine.core.plugin.locale.LocalizedException;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;

public interface ResourcePackHostFactory {
    public ResourcePackHost create(Map<String, Object> var1);

    default public ProxySelector getProxySelector(Map<String, Object> proxySetting) {
        ProxySelector proxy = ProxySelector.getDefault();
        if (proxySetting != null) {
            Object hostObj = proxySetting.get("host");
            if (hostObj == null) {
                throw new LocalizedException("warning.config.host.proxy.missing_host", new NullPointerException("'host' should not be null for proxy setting"), new String[0]);
            }
            String proxyHost = hostObj.toString();
            Object portObj = proxySetting.get("port");
            if (portObj == null) {
                throw new LocalizedException("warning.config.host.proxy.missing_port", new NullPointerException("'port' should not be null for proxy setting"), new String[0]);
            }
            int proxyPort = ResourceConfigUtils.getAsInt(portObj, "port");
            if (proxyHost == null || proxyHost.isEmpty() || proxyPort <= 0 || proxyPort > 65535) {
                throw new LocalizedException("warning.config.host.proxy.invalid", proxyHost + ":" + proxyPort);
            }
            proxy = ProxySelector.of(new InetSocketAddress(proxyHost, proxyPort));
        }
        return proxy;
    }
}

