/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.host.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.momirealms.craftengine.core.pack.host.ResourcePackDownloadData;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.libraries.caffeine.cache.Cache;
import net.momirealms.craftengine.libraries.caffeine.cache.Caffeine;
import net.momirealms.craftengine.libraries.caffeine.cache.Scheduler;
import org.jetbrains.annotations.Nullable;

public class SelfHostHttpServer {
    private static SelfHostHttpServer instance;
    private final Cache<String, Boolean> oneTimePackUrls = Caffeine.newBuilder().maximumSize(256L).scheduler(Scheduler.systemScheduler()).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private final Cache<String, IpAccessRecord> ipAccessCache = Caffeine.newBuilder().maximumSize(256L).scheduler(Scheduler.systemScheduler()).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private final AtomicLong totalRequests = new AtomicLong();
    private final AtomicLong blockedRequests = new AtomicLong();
    private int rateLimit = 1;
    private long rateLimitInterval = 1000L;
    private String ip = "localhost";
    private int port = -1;
    private String protocol = "http";
    private String url;
    private boolean denyNonMinecraft = true;
    private boolean useToken;
    private byte[] resourcePackBytes;
    private String packHash;
    private UUID packUUID;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel serverChannel;

    public static SelfHostHttpServer instance() {
        if (instance == null) {
            instance = new SelfHostHttpServer();
        }
        return instance;
    }

    public void updateProperties(String ip, int port, String url, boolean denyNonMinecraft, String protocol, int maxRequests, int resetInterval, boolean token) {
        this.ip = ip;
        this.url = url;
        this.denyNonMinecraft = denyNonMinecraft;
        this.protocol = protocol;
        this.rateLimit = maxRequests;
        this.rateLimitInterval = resetInterval;
        this.useToken = token;
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        if (this.port == port && this.serverChannel != null) {
            return;
        }
        this.disable();
        this.port = port;
        this.initializeServer();
    }

    public String url() {
        if (this.url != null && !this.url.isEmpty()) {
            return this.url;
        }
        return this.protocol + "://" + this.ip + ":" + this.port + "/";
    }

    private void initializeServer() {
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
                pipeline.addLast(new ChannelHandler[]{new RequestHandler()});
            }
        });
        try {
            this.serverChannel = b.bind(this.port).sync().channel();
            CraftEngine.instance().logger().info("Netty HTTP server started on port: " + this.port);
        }
        catch (InterruptedException e) {
            CraftEngine.instance().logger().warn("Failed to start Netty server", e);
            Thread.currentThread().interrupt();
        }
    }

    @Nullable
    public ResourcePackDownloadData generateOneTimeUrl() {
        if (this.resourcePackBytes == null) {
            return null;
        }
        if (!this.useToken) {
            return new ResourcePackDownloadData(this.url() + "download", this.packUUID, this.packHash);
        }
        String token = UUID.randomUUID().toString();
        this.oneTimePackUrls.put((Object)token, (Object)true);
        return new ResourcePackDownloadData(this.url() + "download?token=" + URLEncoder.encode(token, StandardCharsets.UTF_8), this.packUUID, this.packHash);
    }

    public void disable() {
        if (this.serverChannel != null) {
            this.serverChannel.close().awaitUninterruptibly();
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            this.serverChannel = null;
        }
    }

    public void readResourcePack(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                this.resourcePackBytes = Files.readAllBytes(path);
                this.calculateHash();
            } else {
                this.resourcePackBytes = null;
            }
        }
        catch (IOException e) {
            CraftEngine.instance().logger().severe("Failed to load resource pack", e);
        }
    }

    private void calculateHash() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(this.resourcePackBytes);
            byte[] hashBytes = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                hexString.append(String.format("%02x", b));
            }
            this.packHash = hexString.toString();
            this.packUUID = UUID.nameUUIDFromBytes(this.packHash.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            CraftEngine.instance().logger().severe("SHA-1 algorithm not available", e);
        }
    }

    private static class IpAccessRecord {
        long lastAccessTime;
        int accessCount;

        IpAccessRecord(long lastAccessTime, int accessCount) {
            this.lastAccessTime = lastAccessTime;
            this.accessCount = accessCount;
        }
    }

    @ChannelHandler.Sharable
    private class RequestHandler
    extends SimpleChannelInboundHandler<FullHttpRequest> {
        private RequestHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
            SelfHostHttpServer.this.totalRequests.incrementAndGet();
            try {
                String clientIp = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress();
                if (this.checkRateLimit(clientIp)) {
                    this.sendError(ctx, HttpResponseStatus.TOO_MANY_REQUESTS, "Rate limit exceeded");
                    SelfHostHttpServer.this.blockedRequests.incrementAndGet();
                    return;
                }
                QueryStringDecoder queryDecoder = new QueryStringDecoder(request.uri());
                String path = queryDecoder.path();
                if ("/download".equals(path)) {
                    this.handleDownload(ctx, request, queryDecoder);
                } else if ("/metrics".equals(path)) {
                    this.handleMetrics(ctx);
                } else {
                    this.sendError(ctx, HttpResponseStatus.NOT_FOUND, "Not Found");
                }
            }
            catch (Exception e) {
                CraftEngine.instance().logger().warn("Request handling failed", e);
                this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, "Internal Error");
            }
        }

        private void handleDownload(ChannelHandlerContext ctx, FullHttpRequest request, QueryStringDecoder queryDecoder) {
            String userAgent;
            String token;
            if (SelfHostHttpServer.this.useToken && !this.validateToken(token = (String)queryDecoder.parameters().getOrDefault("token", Collections.emptyList()).stream().findFirst().orElse(null))) {
                this.sendError(ctx, HttpResponseStatus.FORBIDDEN, "Invalid token");
                SelfHostHttpServer.this.blockedRequests.incrementAndGet();
                return;
            }
            if (SelfHostHttpServer.this.denyNonMinecraft && ((userAgent = request.headers().get((CharSequence)HttpHeaderNames.USER_AGENT)) == null || !userAgent.startsWith("Minecraft Java/"))) {
                this.sendError(ctx, HttpResponseStatus.FORBIDDEN, "Invalid client");
                SelfHostHttpServer.this.blockedRequests.incrementAndGet();
                return;
            }
            if (SelfHostHttpServer.this.resourcePackBytes == null) {
                this.sendError(ctx, HttpResponseStatus.NOT_FOUND, "Resource pack missing");
                SelfHostHttpServer.this.blockedRequests.incrementAndGet();
                return;
            }
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])SelfHostHttpServer.this.resourcePackBytes));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/zip").set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)SelfHostHttpServer.this.resourcePackBytes.length);
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }

        private void handleMetrics(ChannelHandlerContext ctx) {
            String metrics = "# TYPE total_requests counter\ntotal_requests " + SelfHostHttpServer.this.totalRequests.get() + "\n# TYPE blocked_requests counter\nblocked_requests " + SelfHostHttpServer.this.blockedRequests.get();
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)metrics, (Charset)CharsetUtil.UTF_8));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain").set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)metrics.length());
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }

        private boolean checkRateLimit(String clientIp) {
            IpAccessRecord record = (IpAccessRecord)SelfHostHttpServer.this.ipAccessCache.getIfPresent((Object)clientIp);
            long now = System.currentTimeMillis();
            if (record == null) {
                record = new IpAccessRecord(now, 1);
                SelfHostHttpServer.this.ipAccessCache.put((Object)clientIp, (Object)record);
                return false;
            }
            if (now - record.lastAccessTime > SelfHostHttpServer.this.rateLimitInterval) {
                record.lastAccessTime = now;
                record.accessCount = 1;
                return false;
            }
            return ++record.accessCount > SelfHostHttpServer.this.rateLimit;
        }

        private boolean validateToken(String token) {
            if (token == null || token.length() != 36) {
                return false;
            }
            Boolean valid = (Boolean)SelfHostHttpServer.this.oneTimePackUrls.getIfPresent((Object)token);
            if (valid != null) {
                SelfHostHttpServer.this.oneTimePackUrls.invalidate((Object)token);
                return true;
            }
            return false;
        }

        private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, String message) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)message, (Charset)CharsetUtil.UTF_8));
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.close();
        }
    }
}

