/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model;

import com.google.gson.JsonObject;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.BaseItemModel;
import net.momirealms.craftengine.core.pack.model.BundleSelectedItemModel;
import net.momirealms.craftengine.core.pack.model.CompositeItemModel;
import net.momirealms.craftengine.core.pack.model.ConditionItemModel;
import net.momirealms.craftengine.core.pack.model.EmptyItemModel;
import net.momirealms.craftengine.core.pack.model.ItemModel;
import net.momirealms.craftengine.core.pack.model.ItemModelFactory;
import net.momirealms.craftengine.core.pack.model.ItemModelReader;
import net.momirealms.craftengine.core.pack.model.RangeDispatchItemModel;
import net.momirealms.craftengine.core.pack.model.SelectItemModel;
import net.momirealms.craftengine.core.pack.model.SpecialItemModel;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceKey;

public class ItemModels {
    public static final Key EMPTY = Key.of("minecraft:empty");
    public static final Key MODEL = Key.of("minecraft:model");
    public static final Key COMPOSITE = Key.of("minecraft:composite");
    public static final Key CONDITION = Key.of("minecraft:condition");
    public static final Key RANGE_DISPATCH = Key.of("minecraft:range_dispatch");
    public static final Key SELECT = Key.of("minecraft:select");
    public static final Key SPECIAL = Key.of("minecraft:special");
    public static final Key BUNDLE_SELECTED_ITEM = Key.of("minecraft:bundle/selected_item");

    public static void registerFactory(Key key, ItemModelFactory factory) {
        ((WritableRegistry)BuiltInRegistries.ITEM_MODEL_FACTORY).register(ResourceKey.create(Registries.ITEM_MODEL_FACTORY.location(), key), factory);
    }

    public static void registerReader(Key key, ItemModelReader reader) {
        ((WritableRegistry)BuiltInRegistries.ITEM_MODEL_READER).register(ResourceKey.create(Registries.ITEM_MODEL_READER.location(), key), reader);
    }

    public static ItemModel fromMap(Map<String, Object> map) {
        String type = map.getOrDefault("type", "minecraft:model").toString();
        Key key = Key.withDefaultNamespace(type, "minecraft");
        ItemModelFactory factory = BuiltInRegistries.ITEM_MODEL_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.item.model.invalid_type", type);
        }
        return factory.create(map);
    }

    public static ItemModel fromJson(JsonObject json) {
        String type = json.get("type").getAsString();
        Key key = Key.withDefaultNamespace(type, "minecraft");
        ItemModelReader reader = BuiltInRegistries.ITEM_MODEL_READER.getValue(key);
        if (reader == null) {
            throw new IllegalArgumentException("Invalid item model type: " + String.valueOf(key));
        }
        return reader.read(json);
    }

    static {
        ItemModels.registerFactory(EMPTY, EmptyItemModel.FACTORY);
        ItemModels.registerReader(EMPTY, EmptyItemModel.READER);
        ItemModels.registerFactory(COMPOSITE, CompositeItemModel.FACTORY);
        ItemModels.registerReader(COMPOSITE, CompositeItemModel.READER);
        ItemModels.registerFactory(MODEL, BaseItemModel.FACTORY);
        ItemModels.registerReader(MODEL, BaseItemModel.READER);
        ItemModels.registerFactory(CONDITION, ConditionItemModel.FACTORY);
        ItemModels.registerReader(CONDITION, ConditionItemModel.READER);
        ItemModels.registerFactory(SPECIAL, SpecialItemModel.FACTORY);
        ItemModels.registerReader(SPECIAL, SpecialItemModel.READER);
        ItemModels.registerFactory(RANGE_DISPATCH, RangeDispatchItemModel.FACTORY);
        ItemModels.registerReader(RANGE_DISPATCH, RangeDispatchItemModel.READER);
        ItemModels.registerFactory(SELECT, SelectItemModel.FACTORY);
        ItemModels.registerReader(SELECT, SelectItemModel.READER);
        ItemModels.registerFactory(BUNDLE_SELECTED_ITEM, BundleSelectedItemModel.FACTORY);
        ItemModels.registerReader(BUNDLE_SELECTED_ITEM, BundleSelectedItemModel.READER);
    }
}

