/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model.select;

import com.google.gson.JsonObject;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.select.SelectProperty;
import net.momirealms.craftengine.core.pack.model.select.SelectPropertyFactory;
import net.momirealms.craftengine.core.pack.model.select.SelectPropertyReader;
import net.momirealms.craftengine.core.util.Key;

public class SimpleSelectProperty
implements SelectProperty {
    public static final Factory FACTORY = new Factory();
    public static final Reader READER = new Reader();
    private final Key type;

    public SimpleSelectProperty(Key type) {
        this.type = type;
    }

    @Override
    public Key type() {
        return this.type;
    }

    @Override
    public void accept(JsonObject jsonObject) {
        jsonObject.addProperty("property", this.type().toString());
    }

    public static class Factory
    implements SelectPropertyFactory {
        @Override
        public SelectProperty create(Map<String, Object> arguments) {
            Key type = Key.of(arguments.get("property").toString());
            return new SimpleSelectProperty(type);
        }
    }

    public static class Reader
    implements SelectPropertyReader {
        @Override
        public SelectProperty read(JsonObject json) {
            Key type = Key.of(json.get("property").getAsString());
            return new SimpleSelectProperty(type);
        }
    }
}

