/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model.tint;

import com.google.gson.JsonObject;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.tint.ConstantTint;
import net.momirealms.craftengine.core.pack.model.tint.CustomModelDataTint;
import net.momirealms.craftengine.core.pack.model.tint.GrassTint;
import net.momirealms.craftengine.core.pack.model.tint.SimpleDefaultTint;
import net.momirealms.craftengine.core.pack.model.tint.Tint;
import net.momirealms.craftengine.core.pack.model.tint.TintFactory;
import net.momirealms.craftengine.core.pack.model.tint.TintReader;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class Tints {
    public static final Key CONSTANT = Key.of("minecraft:constant");
    public static final Key CUSTOM_MODEL_DATA = Key.of("minecraft:custom_model_data");
    public static final Key DYE = Key.of("minecraft:dye");
    public static final Key FIREWORK = Key.of("minecraft:firework");
    public static final Key GRASS = Key.of("minecraft:grass");
    public static final Key MAP_COLOR = Key.of("minecraft:map_color");
    public static final Key POTION = Key.of("minecraft:potion");
    public static final Key TEAM = Key.of("minecraft:team");

    public static void registerFactory(Key key, TintFactory factory) {
        ((WritableRegistry)BuiltInRegistries.TINT_FACTORY).register(ResourceKey.create(Registries.TINT_FACTORY.location(), key), factory);
    }

    public static void registerReader(Key key, TintReader reader) {
        ((WritableRegistry)BuiltInRegistries.TINT_READER).register(ResourceKey.create(Registries.TINT_READER.location(), key), reader);
    }

    public static Tint fromMap(Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.item.model.tint.missing_type");
        Key key = Key.withDefaultNamespace(type, "minecraft");
        TintFactory factory = BuiltInRegistries.TINT_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.item.model.tint.invalid_type", type);
        }
        return factory.create(map);
    }

    public static Tint fromJson(JsonObject json) {
        String type = json.get("type").getAsString();
        Key key = Key.withDefaultNamespace(type, "minecraft");
        TintReader reader = BuiltInRegistries.TINT_READER.getValue(key);
        if (reader == null) {
            throw new IllegalArgumentException("Invalid tint type: " + type);
        }
        return reader.read(json);
    }

    static {
        Tints.registerFactory(CONSTANT, ConstantTint.FACTORY);
        Tints.registerReader(CONSTANT, ConstantTint.READER);
        Tints.registerFactory(CUSTOM_MODEL_DATA, CustomModelDataTint.FACTORY);
        Tints.registerReader(CUSTOM_MODEL_DATA, CustomModelDataTint.READER);
        Tints.registerFactory(GRASS, GrassTint.FACTORY);
        Tints.registerReader(GRASS, GrassTint.READER);
        Tints.registerFactory(DYE, SimpleDefaultTint.FACTORY);
        Tints.registerReader(DYE, SimpleDefaultTint.READER);
        Tints.registerFactory(FIREWORK, SimpleDefaultTint.FACTORY);
        Tints.registerReader(FIREWORK, SimpleDefaultTint.READER);
        Tints.registerFactory(MAP_COLOR, SimpleDefaultTint.FACTORY);
        Tints.registerReader(MAP_COLOR, SimpleDefaultTint.READER);
        Tints.registerFactory(POTION, SimpleDefaultTint.FACTORY);
        Tints.registerReader(POTION, SimpleDefaultTint.READER);
        Tints.registerFactory(TEAM, SimpleDefaultTint.FACTORY);
        Tints.registerReader(TEAM, SimpleDefaultTint.READER);
    }
}

