/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.command;

import net.momirealms.craftengine.core.plugin.Plugin;
import net.momirealms.craftengine.core.plugin.command.CommandConfig;
import net.momirealms.craftengine.core.plugin.command.CommandFeature;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.TranslatableComponent;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.context.CommandContext;

public abstract class AbstractCommandFeature<C>
implements CommandFeature<C> {
    protected final CraftEngineCommandManager<C> commandManager;
    private final Plugin plugin;
    protected CommandConfig<C> commandConfig;

    public AbstractCommandFeature(CraftEngineCommandManager<C> commandManager, Plugin plugin) {
        this.commandManager = commandManager;
        this.plugin = plugin;
    }

    public abstract Command.Builder<? extends C> assembleCommand(CommandManager<C> var1, Command.Builder<C> var2);

    @Override
    public Command<C> registerCommand(CommandManager<C> manager, Command.Builder<C> builder) {
        Command command = this.assembleCommand(manager, builder).build();
        manager.command(command);
        return command;
    }

    @Override
    public void registerRelatedFunctions() {
    }

    @Override
    public void unregisterRelatedFunctions() {
    }

    @Override
    public void handleFeedback(CommandContext<?> context, TranslatableComponent.Builder key, Component ... args) {
        if (context.flags().hasFlag("silent")) {
            return;
        }
        this.commandManager.handleCommandFeedback(context.sender(), key, args);
    }

    @Override
    public void handleFeedback(C sender, TranslatableComponent.Builder key, Component ... args) {
        this.commandManager.handleCommandFeedback(sender, key, args);
    }

    @Override
    public CraftEngineCommandManager<C> commandManager() {
        return this.commandManager;
    }

    @Override
    public CommandConfig<C> commandConfig() {
        return this.commandConfig;
    }

    public void setCommandConfig(CommandConfig<C> commandConfig) {
        this.commandConfig = commandConfig;
    }

    @Override
    public Plugin plugin() {
        return this.plugin;
    }
}

