/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.command;

import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;

public interface ConfigurableCommandBuilder<C> {
    public ConfigurableCommandBuilder<C> permission(String var1);

    public ConfigurableCommandBuilder<C> nodes(String ... var1);

    public Command.Builder<C> build();

    public static class BasicConfigurableCommandBuilder<C>
    implements ConfigurableCommandBuilder<C> {
        private Command.Builder<C> commandBuilder;

        public BasicConfigurableCommandBuilder(CommandManager<C> commandManager, String rootNode) {
            this.commandBuilder = commandManager.commandBuilder(rootNode, new String[0]);
        }

        @Override
        public ConfigurableCommandBuilder<C> permission(String permission) {
            this.commandBuilder = this.commandBuilder.permission(permission);
            return this;
        }

        @Override
        public ConfigurableCommandBuilder<C> nodes(String ... subNodes) {
            for (String sub : subNodes) {
                this.commandBuilder = this.commandBuilder.literal(sub, new String[0]);
            }
            return this;
        }

        @Override
        public Command.Builder<C> build() {
            return this.commandBuilder;
        }
    }
}

