/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.config;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import net.momirealms.craftengine.core.plugin.locale.TranslationManager;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.snakeyaml.LoaderOptions;
import net.momirealms.craftengine.libraries.snakeyaml.constructor.SafeConstructor;
import net.momirealms.craftengine.libraries.snakeyaml.nodes.MappingNode;
import net.momirealms.craftengine.libraries.snakeyaml.nodes.Node;
import net.momirealms.craftengine.libraries.snakeyaml.nodes.NodeTuple;
import net.momirealms.craftengine.libraries.snakeyaml.nodes.ScalarNode;

public class StringKeyConstructor
extends SafeConstructor {
    private final Path path;
    private static final String VERSION_PREFIX = "$$";
    private static final String DEEP_KEY_SEPARATOR = "::";

    public StringKeyConstructor(Path path, LoaderOptions loaderOptions) {
        super(loaderOptions);
        this.path = path;
    }

    private boolean isVersionMatch(String versionSpec) {
        int index = versionSpec.indexOf(126);
        if (index == -1) {
            char firstChar = versionSpec.charAt(0);
            if (firstChar == '>') {
                int version = VersionHelper.parseVersionToInteger(versionSpec);
                return versionSpec.charAt(1) == '=' ? VersionHelper.version() >= version : VersionHelper.version() > version;
            }
            if (firstChar == '<') {
                int version = VersionHelper.parseVersionToInteger(versionSpec);
                return versionSpec.charAt(1) == '=' ? VersionHelper.version() <= version : VersionHelper.version() < version;
            }
            return VersionHelper.parseVersionToInteger(versionSpec) == VersionHelper.version();
        }
        int min = VersionHelper.parseVersionToInteger(versionSpec.substring(0, index));
        int max = VersionHelper.parseVersionToInteger(versionSpec.substring(index + 1));
        return VersionHelper.version() >= min && VersionHelper.version() <= max;
    }

    public Object constructObject(Node node) {
        MappingNode mappingNode;
        if (node instanceof MappingNode && this.isValueSelectorNode(mappingNode = (MappingNode)node)) {
            return this.constructVersionedValue(mappingNode);
        }
        return super.constructObject(node);
    }

    protected Map<Object, Object> constructMapping(MappingNode node) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (NodeTuple tuple : node.getValue()) {
            Node keyNode = tuple.getKeyNode();
            if (!(keyNode instanceof ScalarNode)) continue;
            Node valueNode = tuple.getValueNode();
            String key = this.constructScalar((ScalarNode)keyNode);
            if (key.startsWith(VERSION_PREFIX)) {
                this.processVersionedBlock(map, key, valueNode);
                continue;
            }
            if (key.contains(DEEP_KEY_SEPARATOR)) {
                this.processDeepKey(map, key, valueNode, keyNode);
                continue;
            }
            this.processRegularKey(map, key, valueNode, keyNode);
        }
        return map;
    }

    private void processVersionedBlock(Map<Object, Object> targetMap, String key, Node valueNode) {
        String versionSpec = key.substring(VERSION_PREFIX.length());
        if (this.isVersionMatch(versionSpec)) {
            if (valueNode instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)valueNode;
                Map<Object, Object> versionedMap = this.constructMapping(mappingNode);
                this.mergeMap(targetMap, versionedMap, "", valueNode);
            } else {
                this.logWarning("versioned_key_not_a_map", key, valueNode);
            }
        }
    }

    private void processDeepKey(Map<Object, Object> rootMap, String fullKey, Node valueNode, Node keyNode) {
        CharSequence[] keyParts = fullKey.split(DEEP_KEY_SEPARATOR);
        LinkedHashMap currentMap = rootMap;
        for (int i = 0; i < keyParts.length - 1; ++i) {
            String keyPart = keyParts[i];
            Object existingValue = currentMap.get(keyPart);
            if (existingValue instanceof Map) {
                currentMap = (LinkedHashMap)existingValue;
                continue;
            }
            if (existingValue != null) {
                this.logWarning("inconsistent_value_type", keyPart, keyNode);
            }
            LinkedHashMap newMap = new LinkedHashMap();
            currentMap.put(keyPart, newMap);
            currentMap = newMap;
        }
        String finalKey = keyParts[keyParts.length - 1];
        Object newValue = this.constructObject(valueNode);
        String keyPath = String.join((CharSequence)DEEP_KEY_SEPARATOR, keyParts);
        this.setValueWithDuplicationCheck(currentMap, finalKey, newValue, keyPath, keyNode);
    }

    private void processRegularKey(Map<Object, Object> targetMap, String key, Node valueNode, Node keyNode) {
        Object newValue = this.constructObject(valueNode);
        this.setValueWithDuplicationCheck(targetMap, key, newValue, key, keyNode);
    }

    private void setValueWithDuplicationCheck(Map<Object, Object> targetMap, String key, Object newValue, String fullKeyPath, Node keyNode) {
        Object existingValue = targetMap.get(key);
        if (existingValue == null) {
            targetMap.put(key, newValue);
        } else if (existingValue instanceof Map && newValue instanceof Map) {
            this.mergeMap((Map)existingValue, (Map)newValue, fullKeyPath, keyNode);
        } else {
            this.logWarning("duplicated_key", fullKeyPath, keyNode);
            targetMap.put(key, newValue);
        }
    }

    private void mergeMap(Map<Object, Object> target, Map<Object, Object> source, String parentPath, Node sourceNode) {
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            String currentPath;
            String key = entry.getKey().toString();
            Object sourceValue = entry.getValue();
            Object targetValue = target.get(key);
            String string = currentPath = parentPath.isEmpty() ? key : parentPath + DEEP_KEY_SEPARATOR + key;
            if (targetValue == null) {
                target.put(key, sourceValue);
                continue;
            }
            if (targetValue instanceof Map && sourceValue instanceof Map) {
                this.mergeMap((Map)targetValue, (Map)sourceValue, currentPath, sourceNode);
                continue;
            }
            this.logWarning("duplicated_key", currentPath, sourceNode);
            target.put(key, sourceValue);
        }
    }

    private boolean isValueSelectorNode(MappingNode node) {
        if (node.getValue().isEmpty()) {
            return false;
        }
        for (NodeTuple tuple : node.getValue()) {
            Node node2 = tuple.getKeyNode();
            if (node2 instanceof ScalarNode) {
                ScalarNode scalarNode = (ScalarNode)node2;
                String key = scalarNode.getValue();
                if (key.startsWith(VERSION_PREFIX)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private Object constructVersionedValue(MappingNode node) {
        Object fallbackValue = null;
        Object matchedValue = null;
        for (NodeTuple tuple : node.getValue()) {
            String key = ((ScalarNode)tuple.getKeyNode()).getValue();
            String versionSpec = key.substring(VERSION_PREFIX.length());
            if ("fallback".equals(versionSpec)) {
                fallbackValue = this.constructObject(tuple.getValueNode());
                continue;
            }
            if (!this.isVersionMatch(versionSpec)) continue;
            matchedValue = this.constructObject(tuple.getValueNode());
        }
        return matchedValue != null ? matchedValue : fallbackValue;
    }

    private void logWarning(String keyInLocale, String configKey, Node node) {
        if (this.path == null) {
            return;
        }
        TranslationManager.instance().log("warning.config.yaml." + keyInLocale, this.path.toAbsolutePath().toString(), configKey, String.valueOf(node.getStartMark().getLine() + 1));
    }
}

