/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.plugin.context.AbstractCommonContext;
import net.momirealms.craftengine.core.plugin.context.AdditionalParameterProvider;
import net.momirealms.craftengine.core.plugin.context.ChainParameterProvider;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.ContextKey;
import net.momirealms.craftengine.core.plugin.context.parameter.BlockParameterProvider;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.plugin.context.parameter.EntityParameterProvider;
import net.momirealms.craftengine.core.plugin.context.parameter.FurnitureParameterProvider;
import net.momirealms.craftengine.core.plugin.context.parameter.ItemParameterProvider;
import net.momirealms.craftengine.core.plugin.context.parameter.PlayerParameterProvider;
import net.momirealms.craftengine.core.plugin.context.parameter.PositionParameterProvider;
import net.momirealms.craftengine.core.plugin.context.parameter.WorldParameterProvider;

public abstract class AbstractChainParameterContext
extends AbstractCommonContext {
    private static final Map<ContextKey<?>, ChainParameterProvider<?>> CHAIN_PARAMETERS = new HashMap();

    private static <T> ChainParameterProvider<T> getParameterProvider(ContextKey<?> key) {
        return CHAIN_PARAMETERS.get(key);
    }

    public AbstractChainParameterContext(ContextHolder contexts) {
        super(contexts);
    }

    public AbstractChainParameterContext(ContextHolder contexts, List<AdditionalParameterProvider> additionalParameterProviders) {
        super(contexts, additionalParameterProviders);
    }

    @Override
    public <T> Optional<T> getOptionalParameter(ContextKey<T> parameter) {
        ContextKey parentKey = parameter.parent();
        if (parentKey == null) {
            return super.getOptionalParameter(parameter);
        }
        if (!CHAIN_PARAMETERS.containsKey(parentKey)) {
            return Optional.empty();
        }
        Optional parentValue = this.getOptionalParameter(parentKey);
        if (parentValue.isEmpty()) {
            return Optional.empty();
        }
        return AbstractChainParameterContext.getParameterProvider(parentKey).getOptionalParameter(parameter, parentValue.get());
    }

    static {
        CHAIN_PARAMETERS.put(DirectContextParameters.PLAYER, new PlayerParameterProvider());
        CHAIN_PARAMETERS.put(DirectContextParameters.WORLD, new WorldParameterProvider());
        CHAIN_PARAMETERS.put(DirectContextParameters.BLOCK, new BlockParameterProvider());
        CHAIN_PARAMETERS.put(DirectContextParameters.POSITION, new PositionParameterProvider());
        CHAIN_PARAMETERS.put(DirectContextParameters.FURNITURE, new FurnitureParameterProvider());
        CHAIN_PARAMETERS.put(DirectContextParameters.ENTITY, new EntityParameterProvider());
        ItemParameterProvider itemProvider = new ItemParameterProvider();
        CHAIN_PARAMETERS.put(DirectContextParameters.MAIN_HAND_ITEM, itemProvider);
        CHAIN_PARAMETERS.put(DirectContextParameters.OFF_HAND_ITEM, itemProvider);
        CHAIN_PARAMETERS.put(DirectContextParameters.FURNITURE_ITEM, itemProvider);
        CHAIN_PARAMETERS.put(DirectContextParameters.ITEM_IN_HAND, itemProvider);
    }
}

