/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.condition.AllOfCondition;
import net.momirealms.craftengine.core.plugin.context.condition.CommonConditions;
import net.momirealms.craftengine.core.plugin.context.condition.ConditionFactory;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;

public class InvertedCondition<CTX extends Context>
implements Condition<CTX> {
    protected final Condition<CTX> condition;

    public InvertedCondition(Condition<CTX> condition) {
        this.condition = condition;
    }

    @Override
    public boolean test(CTX ctx) {
        return !this.condition.test(ctx);
    }

    @Override
    public Key type() {
        return CommonConditions.INVERTED;
    }

    public static class FactoryImpl<CTX extends Context>
    implements ConditionFactory<CTX> {
        private final Function<Map<String, Object>, Condition<CTX>> factory;

        public FactoryImpl(Function<Map<String, Object>, Condition<CTX>> factory) {
            this.factory = factory;
        }

        @Override
        public Condition<CTX> create(Map<String, Object> arguments) {
            Object termObj = ResourceConfigUtils.requireNonNullOrThrow(ResourceConfigUtils.get(arguments, "term", "terms"), "warning.config.condition.inverted.missing_term");
            if (termObj instanceof Map) {
                Map map = (Map)termObj;
                return new InvertedCondition<CTX>(this.factory.apply(MiscUtils.castToMap(map, false)));
            }
            if (termObj instanceof List) {
                List list = (List)termObj;
                ArrayList<Condition<CTX>> conditions = new ArrayList<Condition<CTX>>();
                for (Map term : list) {
                    conditions.add(this.factory.apply(term));
                }
                return new InvertedCondition(new AllOfCondition(conditions));
            }
            throw new LocalizedResourceConfigException("warning.config.condition.inverted.invalid_term_type", termObj.getClass().getSimpleName());
        }
    }
}

