/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.condition;

import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.condition.CommonConditions;
import net.momirealms.craftengine.core.plugin.context.condition.ConditionFactory;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.RandomUtils;

public class SurvivesExplosionCondition<CTX extends Context>
implements Condition<CTX> {
    @Override
    public Key type() {
        return CommonConditions.SURVIVES_EXPLOSION;
    }

    @Override
    public boolean test(CTX ctx) {
        Optional<Float> radius = ctx.getOptionalParameter(DirectContextParameters.EXPLOSION_RADIUS);
        if (radius.isPresent()) {
            float f = 1.0f / radius.get().floatValue();
            return RandomUtils.generateRandomFloat(0.0f, 1.0f) < f;
        }
        return true;
    }

    public static class FactoryImpl<CTX extends Context>
    implements ConditionFactory<CTX> {
        @Override
        public Condition<CTX> create(Map<String, Object> arguments) {
            return new SurvivesExplosionCondition();
        }
    }
}

