/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum EventTrigger {
    LEFT_CLICK("attack", "left_click"),
    RIGHT_CLICK("right_click", "use_on", "use", "use_item_on"),
    CONSUME("eat", "consume", "drink"),
    BREAK("break", "dig"),
    PLACE("place", "build"),
    STEP("step");

    public static final Map<String, EventTrigger> BY_NAME;
    private final String[] names;

    private EventTrigger(String ... names) {
        this.names = names;
    }

    public String[] names() {
        return this.names;
    }

    public static EventTrigger byName(String name) {
        return Optional.ofNullable(BY_NAME.get(name)).orElseThrow(() -> new IllegalArgumentException("Unknown event trigger: " + name));
    }

    static {
        BY_NAME = new HashMap<String, EventTrigger>();
        for (EventTrigger trigger : EventTrigger.values()) {
            for (String name : trigger.names()) {
                BY_NAME.put(name, trigger);
            }
        }
    }
}

