/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.number;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.plugin.context.number.ExpressionNumberProvider;
import net.momirealms.craftengine.core.plugin.context.number.FixedNumberProvider;
import net.momirealms.craftengine.core.plugin.context.number.NumberProvider;
import net.momirealms.craftengine.core.plugin.context.number.NumberProviderFactory;
import net.momirealms.craftengine.core.plugin.context.number.UniformNumberProvider;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class NumberProviders {
    public static final Key FIXED = Key.of("craftengine:fixed");
    public static final Key CONSTANT = Key.of("craftengine:constant");
    public static final Key UNIFORM = Key.of("craftengine:uniform");
    public static final Key EXPRESSION = Key.of("craftengine:expression");

    public static void register(Key key, NumberProviderFactory factory) {
        ((WritableRegistry)BuiltInRegistries.NUMBER_PROVIDER_FACTORY).register(ResourceKey.create(Registries.NUMBER_PROVIDER_FACTORY.location(), key), factory);
    }

    public static List<NumberProvider> fromMapList(List<Map<String, Object>> mapList) {
        if (mapList == null || mapList.isEmpty()) {
            return List.of();
        }
        ArrayList<NumberProvider> functions = new ArrayList<NumberProvider>();
        for (Map<String, Object> map : mapList) {
            functions.add(NumberProviders.fromMap(map));
        }
        return functions;
    }

    public static NumberProvider direct(double value) {
        return new FixedNumberProvider(value);
    }

    public static NumberProvider fromMap(Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.number.missing_type");
        Key key = Key.withDefaultNamespace(type, "craftengine");
        NumberProviderFactory factory = BuiltInRegistries.NUMBER_PROVIDER_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.number.invalid_type", type);
        }
        return factory.create(map);
    }

    public static NumberProvider fromObject(Object object) {
        if (object == null) {
            throw new LocalizedResourceConfigException("warning.config.number.missing_argument", new String[0]);
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return new FixedNumberProvider(number.floatValue());
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return NumberProviders.fromMap(map);
        }
        String string = object.toString();
        if (string.contains("~")) {
            int first = string.indexOf(126);
            int second = string.indexOf(126, first + 1);
            if (second == -1) {
                NumberProvider min = NumberProviders.fromObject(string.substring(0, first));
                NumberProvider max = NumberProviders.fromObject(string.substring(first + 1));
                return new UniformNumberProvider(min, max);
            }
            throw new LocalizedResourceConfigException("warning.config.number.invalid_format", string);
        }
        if (string.contains("<") && string.contains(">") && string.contains(":")) {
            return new ExpressionNumberProvider(string);
        }
        try {
            return new FixedNumberProvider(Float.parseFloat(string));
        }
        catch (NumberFormatException e) {
            throw new LocalizedResourceConfigException("warning.config.number.invalid_format", e, string);
        }
    }

    static {
        NumberProviders.register(FIXED, FixedNumberProvider.FACTORY);
        NumberProviders.register(CONSTANT, FixedNumberProvider.FACTORY);
        NumberProviders.register(UNIFORM, UniformNumberProvider.FACTORY);
        NumberProviders.register(EXPRESSION, ExpressionNumberProvider.FACTORY);
    }
}

