/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.dependency;

import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import net.momirealms.craftengine.core.plugin.PluginProperties;
import net.momirealms.craftengine.core.plugin.dependency.relocation.Relocation;

public class Dependency {
    private final String id;
    private final String groupId;
    private final String rawArtifactId;
    private final List<Relocation> relocations;
    private final Predicate<Path> verifier;
    private static final String MAVEN_FORMAT = "%s/%s/%s/%s-%s.jar";

    public Dependency(String id, String groupId, String artifactId, List<Relocation> relocations) {
        this.id = id;
        this.groupId = groupId;
        this.rawArtifactId = artifactId;
        this.relocations = relocations;
        this.verifier = p -> true;
    }

    public Dependency(String id, String groupId, String artifactId, List<Relocation> relocations, Predicate<Path> verifier) {
        this.id = id;
        this.groupId = groupId;
        this.rawArtifactId = artifactId;
        this.relocations = relocations;
        this.verifier = verifier;
    }

    public boolean verify(Path remapped) {
        return this.verifier.test(remapped);
    }

    public String id() {
        return this.id;
    }

    public String groupId() {
        return this.groupId;
    }

    public String rawArtifactId() {
        return this.rawArtifactId;
    }

    public List<Relocation> relocations() {
        return this.relocations;
    }

    public String toLocalPath() {
        return Dependency.rewriteEscaping(this.groupId).replace(".", "/") + "/" + this.rawArtifactId + "/" + this.getVersion();
    }

    public String mavenPath() {
        return String.format(MAVEN_FORMAT, Dependency.rewriteEscaping(this.groupId).replace(".", "/"), Dependency.rewriteEscaping(this.rawArtifactId), this.getVersion(), Dependency.rewriteEscaping(this.rawArtifactId), this.getVersion());
    }

    public String fileName(String classifier) {
        String name = this.rawArtifactId.toLowerCase(Locale.ENGLISH).replace('_', '-');
        String extra = classifier == null || classifier.isEmpty() ? "" : "-" + classifier;
        return name + "-" + this.getVersion() + extra + ".jar";
    }

    public String getVersion() {
        return PluginProperties.getValue(this.id);
    }

    public static String rewriteEscaping(String s) {
        return s.replace("{}", ".");
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency that = (Dependency)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Dependency{id='" + this.id + "', groupId='" + this.groupId + "'}";
    }
}

