/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.text.minimessage;

import java.util.List;
import java.util.Objects;
import net.momirealms.craftengine.libraries.adventure.text.ComponentLike;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.Context;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.ParsingException;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.Tag;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedArgumentTag
implements TagResolver {
    private final List<? extends ComponentLike> argumentComponents;

    public IndexedArgumentTag(@NotNull List<? extends ComponentLike> argumentComponents) {
        this.argumentComponents = Objects.requireNonNull(argumentComponents, "argumentComponents");
    }

    @Nullable
    public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments, @NotNull Context ctx) throws ParsingException {
        if (!this.has(name)) {
            return null;
        }
        int index = arguments.popOr("No argument number provided").asInt().orElseThrow(() -> ctx.newException("Invalid argument number", arguments));
        if (index < 0 || index >= this.argumentComponents.size()) {
            throw ctx.newException("Invalid argument number", arguments);
        }
        return Tag.selfClosingInserting((ComponentLike)this.argumentComponents.get(index));
    }

    public boolean has(@NotNull String name) {
        return name.equals("arg");
    }
}

