/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ByteProcessor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.momirealms.craftengine.core.registry.Registry;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MCUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.nbt.NBT;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FriendlyByteBuf
extends ByteBuf {
    private final ByteBuf source;

    public FriendlyByteBuf(ByteBuf parent) {
        this.source = parent;
    }

    public ByteBuf source() {
        return this.source;
    }

    public Component readComponent() {
        if (VersionHelper.isOrAbove1_20_3()) {
            return AdventureHelper.nbtToComponent(this.readNbt(false));
        }
        return AdventureHelper.jsonToComponent(this.readUtf());
    }

    public void writeComponent(Component component) {
        if (VersionHelper.isOrAbove1_20_3()) {
            this.writeNbt(AdventureHelper.componentToNbt(component), false);
        } else {
            this.writeUtf(AdventureHelper.componentToJson(component));
        }
    }

    public Instant readInstant() {
        return Instant.ofEpochMilli(this.readLong());
    }

    public void writeInstant(Instant instant) {
        this.writeLong(instant.toEpochMilli());
    }

    public <T, C extends Collection<T>> C readCollection(IntFunction<C> collectionFactory, Reader<T> reader) {
        int i = this.readVarInt();
        Collection collection = (Collection)collectionFactory.apply(i);
        for (int j = 0; j < i; ++j) {
            collection.add(reader.apply(this));
        }
        return (C)collection;
    }

    public <T> void writeCollection(Collection<T> collection, Writer<T> writer) {
        this.writeVarInt(collection.size());
        for (T t : collection) {
            writer.accept(this, t);
        }
    }

    public <T> T[] readArray(Reader<T> reader, Class<T> type) {
        int i = this.readVarInt();
        Object[] array = (Object[])Array.newInstance(type, i);
        for (int j = 0; j < i; ++j) {
            array[j] = reader.apply(this);
        }
        return array;
    }

    public <T> void writeArray(T[] array, Writer<T> writer) {
        this.writeVarInt(array.length);
        for (T t : array) {
            writer.accept(this, t);
        }
    }

    public BlockPos readBlockPos() {
        return BlockPos.of(this.readLong());
    }

    public OptionalInt readOptionalVarInt() {
        int i = this.readVarInt();
        return i == 0 ? OptionalInt.empty() : OptionalInt.of(i - 1);
    }

    public void writeOptionalVarInt(OptionalInt optionalInt) {
        if (optionalInt.isPresent()) {
            this.writeVarInt(optionalInt.getAsInt() + 1);
        } else {
            this.writeVarInt(0);
        }
    }

    public int readContainerId() {
        return VersionHelper.isOrAbove1_21_2() ? this.readVarInt() : (int)this.readUnsignedByte();
    }

    public void writeContainerId(int id) {
        if (VersionHelper.isOrAbove1_21_2()) {
            this.writeVarInt(id);
        } else {
            this.writeByte(id);
        }
    }

    public List<String> readStringList() {
        int i = this.readVarInt();
        ArrayList<String> list = new ArrayList<String>(i);
        for (int j = 0; j < i; ++j) {
            list.add(this.readUtf());
        }
        return list;
    }

    public void writeStringList(List<String> list) {
        this.writeVarInt(list.size());
        for (String s : list) {
            this.writeUtf(s);
        }
    }

    public FriendlyByteBuf writeBlockPos(BlockPos pos) {
        this.writeLong(pos.asLong());
        return this;
    }

    public static int getVarIntSize(int value) {
        for (int shift = 1; shift < 5; ++shift) {
            if ((value & -1 << shift * 7) != 0) continue;
            return shift;
        }
        return 5;
    }

    public static int getVarLongSize(long value) {
        for (int shift = 1; shift < 10; ++shift) {
            if ((value & -1L << shift * 7) != 0L) continue;
            return shift;
        }
        return 10;
    }

    public IntList readIntIdList() {
        int listSize = this.readVarInt();
        IntArrayList idList = new IntArrayList();
        for (int i = 0; i < listSize; ++i) {
            idList.add(this.readVarInt());
        }
        return idList;
    }

    public void writeIntIdList(IntList idList) {
        this.writeVarInt(idList.size());
        idList.forEach(this::writeVarInt);
    }

    public List<byte[]> readByteArrayList() {
        int listSize = this.readVarInt();
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        for (int i = 0; i < listSize; ++i) {
            bytes.add(this.readByteArray());
        }
        return bytes;
    }

    public List<byte[]> readByteArrayList(int maxSize) {
        int listSize = this.readVarInt();
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        for (int i = 0; i < listSize; ++i) {
            bytes.add(this.readByteArray(maxSize));
        }
        return bytes;
    }

    public void writeByteArrayList(List<byte[]> bytes) {
        this.writeVarInt(bytes.size());
        bytes.forEach(this::writeByteArray);
    }

    public <K, V, M extends Map<K, V>> M readMap(IntFunction<M> mapFactory, Reader<K> keyReader, Reader<V> valueReader) {
        int mapSize = this.readVarInt();
        Map map = (Map)mapFactory.apply(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            Object key = keyReader.apply((K)((Object)this));
            Object value = valueReader.apply((V)((Object)this));
            map.put(key, value);
        }
        return (M)map;
    }

    public <K, V> Map<K, V> readMap(Reader<K> keyReader, Reader<V> valueReader) {
        return this.readMap(Maps::newHashMapWithExpectedSize, keyReader, valueReader);
    }

    public <K, V> void writeMap(Map<K, V> map, Writer<K> keyWriter, Writer<V> valueWriter) {
        this.writeVarInt(map.size());
        map.forEach((key, value) -> {
            keyWriter.accept((Object)((Object)this), key);
            valueWriter.accept((Object)((Object)this), value);
        });
    }

    public void readWithCount(Consumer<FriendlyByteBuf> consumer) {
        int count = this.readVarInt();
        for (int i = 0; i < count; ++i) {
            consumer.accept(this);
        }
    }

    public <E extends Enum<E>> void writeEnumSet(EnumSet<E> enumSet, Class<E> enumType) {
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        BitSet bitSet = new BitSet(enumConstants.length);
        for (int i = 0; i < enumConstants.length; ++i) {
            bitSet.set(i, enumSet.contains(enumConstants[i]));
        }
        this.writeFixedBitSet(bitSet, enumConstants.length);
    }

    public <E extends Enum<E>> EnumSet<E> readEnumSet(Class<E> enumType) {
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        BitSet bitSet = this.readFixedBitSet(enumConstants.length);
        EnumSet<Enum> enumSet = EnumSet.noneOf(enumType);
        for (int i = 0; i < enumConstants.length; ++i) {
            if (!bitSet.get(i)) continue;
            enumSet.add(enumConstants[i]);
        }
        return enumSet;
    }

    public <T> void writeOptional(Optional<T> value, Writer<T> writer) {
        if (value.isPresent()) {
            this.writeBoolean(true);
            writer.accept(this, value.get());
        } else {
            this.writeBoolean(false);
        }
    }

    public <T> Optional<T> readOptional(Reader<T> reader) {
        return this.readBoolean() ? Optional.of(reader.apply(this)) : Optional.empty();
    }

    @Nullable
    public <T> T readNullable(Reader<T> reader) {
        return this.readBoolean() ? (T)reader.apply(this) : null;
    }

    public <T> void writeNullable(@Nullable T value, Writer<T> writer) {
        if (value != null) {
            this.writeBoolean(true);
            writer.accept(this, value);
        } else {
            this.writeBoolean(false);
        }
    }

    public byte[] readByteArray() {
        return this.readByteArray(this.readableBytes());
    }

    public FriendlyByteBuf writeByteArray(byte[] array) {
        this.writeVarInt(array.length);
        this.writeBytes(array);
        return this;
    }

    public byte[] readByteArray(int maxSize) {
        int arraySize = this.readVarInt();
        if (arraySize > maxSize) {
            throw new DecoderException("ByteArray with size " + arraySize + " is bigger than allowed " + maxSize);
        }
        byte[] byteArray = new byte[arraySize];
        this.readBytes(byteArray);
        return byteArray;
    }

    public FriendlyByteBuf writeVarIntArray(int[] array) {
        this.writeVarInt(array.length);
        for (int value : array) {
            this.writeVarInt(value);
        }
        return this;
    }

    public int[] readVarIntArray() {
        return this.readVarIntArray(this.readableBytes());
    }

    public int[] readVarIntArray(int maxSize) {
        int arraySize = this.readVarInt();
        if (arraySize > maxSize) {
            throw new DecoderException("VarIntArray with size " + arraySize + " is bigger than allowed " + maxSize);
        }
        int[] array = new int[arraySize];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readVarInt();
        }
        return array;
    }

    public FriendlyByteBuf writeLongArray(long[] array) {
        this.writeVarInt(array.length);
        for (long value : array) {
            this.writeLong(value);
        }
        return this;
    }

    public FriendlyByteBuf writeFixedSizeLongArray(long[] array) {
        for (long value : array) {
            this.writeLong(value);
        }
        return this;
    }

    public long[] readFixedSizeLongArray(long[] output) {
        for (int i = 0; i < output.length; ++i) {
            output[i] = this.readLong();
        }
        return output;
    }

    public long[] readLongArray() {
        return this.readLongArray(null);
    }

    public long[] readLongArray(long @Nullable [] toArray) {
        return this.readLongArray(toArray, this.readableBytes() / 8);
    }

    public long[] readLongArray(long @Nullable [] toArray, int maxSize) {
        int arraySize = this.readVarInt();
        if (toArray == null || toArray.length != arraySize) {
            if (arraySize > maxSize) {
                throw new DecoderException("LongArray with size " + arraySize + " is bigger than allowed " + maxSize);
            }
            toArray = new long[arraySize];
        }
        for (int i = 0; i < toArray.length; ++i) {
            toArray[i] = this.readLong();
        }
        return toArray;
    }

    public byte[] extractByteBufContents() {
        int size = this.writerIndex();
        byte[] byteArray = new byte[size];
        this.getBytes(0, byteArray);
        return byteArray;
    }

    public <T> T readById(Registry<T> registry) {
        int id = this.readVarInt();
        return registry.getValue(id);
    }

    public <T> void writeById(Registry<T> registry, T value) {
        this.writeVarInt(registry.getId(value));
    }

    public int readVarInt() {
        byte byteValue;
        int value = 0;
        int shift = 0;
        do {
            byteValue = this.readByte();
            value |= (byteValue & 0x7F) << shift++ * 7;
            if (shift <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((byteValue & 0x80) == 128);
        return value;
    }

    public long readVarLong() {
        byte byteValue;
        long value = 0L;
        int shift = 0;
        do {
            byteValue = this.readByte();
            value |= (long)(byteValue & 0x7F) << shift++ * 7;
            if (shift <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((byteValue & 0x80) == 128);
        return value;
    }

    public FriendlyByteBuf writeUUID(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
        return this;
    }

    public UUID readUUID() {
        return new UUID(this.readLong(), this.readLong());
    }

    public FriendlyByteBuf writeVarInt(int value) {
        while ((value & 0xFFFFFF80) != 0) {
            this.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.writeByte(value & 0x7F);
        return this;
    }

    public <T> Either<Integer, T> readHolder(Reader<T> reader) {
        int id = this.readVarInt();
        if (id == 0) {
            return Either.right(reader.apply(this));
        }
        return Either.left((Object)(id - 1));
    }

    public <T> void writeHolder(Either<Integer, T> holder, Writer<T> writer) {
        holder.ifLeft(i -> this.writeVarInt(i + 1)).ifRight(t -> {
            this.writeVarInt(0);
            writer.accept(this, t);
        });
    }

    public Either<List<Integer>, Key> readHolderSet() {
        int id = this.readVarInt();
        if (id == 0) {
            return Either.right((Object)this.readKey());
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < id - 1; ++i) {
            list.add(this.readVarInt());
        }
        return Either.left(list);
    }

    public void writeHolderSet(Either<List<Integer>, Key> holderSet) {
        holderSet.ifLeft(ints -> {
            this.writeVarInt(ints.size() + 1);
            for (Integer anInt : ints) {
                this.writeVarInt(anInt);
            }
        }).ifRight(key -> {
            this.writeVarInt(0);
            this.writeKey((Key)key);
        });
    }

    public FriendlyByteBuf writeVarLong(long value) {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((int)(value & 0x7FL) | 0x80);
            value >>>= 7;
        }
        this.writeByte((int)(value & 0x7FL));
        return this;
    }

    public FriendlyByteBuf writeNbt(@Nullable Tag compound, boolean named) {
        if (compound == null) {
            this.writeByte(0);
        } else {
            try {
                NBT.writeUnnamedTag(compound, (DataOutput)new ByteBufOutputStream((ByteBuf)this), named);
            }
            catch (IOException e) {
                throw new EncoderException("Failed to write NBT compound: " + e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    @Nullable
    public Tag readNbt(boolean named) {
        int initialIndex = this.readerIndex();
        byte marker = this.readByte();
        if (marker == 0) {
            return null;
        }
        this.readerIndex(initialIndex);
        try {
            return NBT.readUnnamedTag((DataInput)new ByteBufInputStream((ByteBuf)this), named);
        }
        catch (IOException e) {
            throw new EncoderException("Failed to read NBT compound: " + e.getMessage(), (Throwable)e);
        }
    }

    public String readUtf() {
        return this.readUtf(Short.MAX_VALUE);
    }

    public String readUtf(int maxLength) {
        int maxEncodedLength = FriendlyByteBuf.getMaxEncodedUtfLength(maxLength);
        int length = this.readVarInt();
        if (length > maxEncodedLength) {
            throw new DecoderException("Encoded string length exceeds maximum allowed: " + length + " > " + maxEncodedLength);
        }
        if (length < 0) {
            throw new DecoderException("Encoded string length is negative: " + length);
        }
        String result = this.toString(this.readerIndex(), length, StandardCharsets.UTF_8);
        this.readerIndex(this.readerIndex() + length);
        if (result.length() > maxLength) {
            throw new DecoderException("Decoded string length exceeds maximum allowed: " + result.length() + " > " + maxLength);
        }
        return result;
    }

    public FriendlyByteBuf writeUtf(String string) {
        return this.writeUtf(string, Short.MAX_VALUE);
    }

    public FriendlyByteBuf writeUtf(String string, int maxLength) {
        int maxEncodedLength;
        if (string.length() > maxLength) {
            throw new EncoderException("String too large (was " + string.length() + " characters, max " + maxLength + ")");
        }
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > (maxEncodedLength = FriendlyByteBuf.getMaxEncodedUtfLength(maxLength))) {
            throw new EncoderException("Encoded string too large (was " + bytes.length + " bytes, max " + maxEncodedLength + ")");
        }
        this.writeVarInt(bytes.length);
        this.writeBytes(bytes);
        return this;
    }

    private static int getMaxEncodedUtfLength(int decodedLength) {
        return decodedLength * 3;
    }

    public Key readKey() {
        return Key.of(this.readUtf(Short.MAX_VALUE));
    }

    public FriendlyByteBuf writeKey(Key id) {
        this.writeUtf(id.toString());
        return this;
    }

    public BitSet readBitSet() {
        return BitSet.valueOf(this.readLongArray());
    }

    public void writeBitSet(BitSet bitSet) {
        this.writeLongArray(bitSet.toLongArray());
    }

    public BitSet readFixedBitSet(int size) {
        byte[] byteArray = new byte[MCUtils.positiveCeilDiv(size, 8)];
        this.readBytes(byteArray);
        return BitSet.valueOf(byteArray);
    }

    public void writeFixedBitSet(BitSet bitSet, int size) {
        if (bitSet.length() > size) {
            throw new EncoderException("BitSet length exceeds expected size (" + bitSet.length() + " > " + size + ")");
        }
        byte[] byteArray = bitSet.toByteArray();
        this.writeBytes(Arrays.copyOf(byteArray, MCUtils.positiveCeilDiv(size, 8)));
    }

    public <T extends Enum<T>> T readEnumConstant(Class<T> enumClass) {
        return (T)((Enum[])enumClass.getEnumConstants())[this.readVarInt()];
    }

    public FriendlyByteBuf writeEnumConstant(Enum<?> instance) {
        return this.writeVarInt(instance.ordinal());
    }

    public int capacity() {
        return this.source.capacity();
    }

    public ByteBuf capacity(int i) {
        return this.source.capacity(i);
    }

    public int maxCapacity() {
        return this.source.maxCapacity();
    }

    public ByteBufAllocator alloc() {
        return this.source.alloc();
    }

    public ByteOrder order() {
        return this.source.order();
    }

    public ByteBuf order(ByteOrder byteorder) {
        return this.source.order(byteorder);
    }

    public ByteBuf unwrap() {
        return this.source.unwrap();
    }

    public boolean isDirect() {
        return this.source.isDirect();
    }

    public boolean isReadOnly() {
        return this.source.isReadOnly();
    }

    public ByteBuf asReadOnly() {
        return this.source.asReadOnly();
    }

    public int readerIndex() {
        return this.source.readerIndex();
    }

    public ByteBuf readerIndex(int i) {
        return this.source.readerIndex(i);
    }

    public int writerIndex() {
        return this.source.writerIndex();
    }

    public ByteBuf writerIndex(int i) {
        return this.source.writerIndex(i);
    }

    public ByteBuf setIndex(int i, int j) {
        return this.source.setIndex(i, j);
    }

    public int readableBytes() {
        return this.source.readableBytes();
    }

    public int writableBytes() {
        return this.source.writableBytes();
    }

    public int maxWritableBytes() {
        return this.source.maxWritableBytes();
    }

    public boolean isReadable() {
        return this.source.isReadable();
    }

    public boolean isReadable(int i) {
        return this.source.isReadable(i);
    }

    public boolean isWritable() {
        return this.source.isWritable();
    }

    public boolean isWritable(int i) {
        return this.source.isWritable(i);
    }

    public ByteBuf clear() {
        return this.source.clear();
    }

    public ByteBuf markReaderIndex() {
        return this.source.markReaderIndex();
    }

    public ByteBuf resetReaderIndex() {
        return this.source.resetReaderIndex();
    }

    public ByteBuf markWriterIndex() {
        return this.source.markWriterIndex();
    }

    public ByteBuf resetWriterIndex() {
        return this.source.resetWriterIndex();
    }

    public ByteBuf discardReadBytes() {
        return this.source.discardReadBytes();
    }

    public ByteBuf discardSomeReadBytes() {
        return this.source.discardSomeReadBytes();
    }

    public ByteBuf ensureWritable(int i) {
        return this.source.ensureWritable(i);
    }

    public int ensureWritable(int i, boolean flag) {
        return this.source.ensureWritable(i, flag);
    }

    public boolean getBoolean(int i) {
        return this.source.getBoolean(i);
    }

    public byte getByte(int i) {
        return this.source.getByte(i);
    }

    public short getUnsignedByte(int i) {
        return this.source.getUnsignedByte(i);
    }

    public short getShort(int i) {
        return this.source.getShort(i);
    }

    public short getShortLE(int i) {
        return this.source.getShortLE(i);
    }

    public int getUnsignedShort(int i) {
        return this.source.getUnsignedShort(i);
    }

    public int getUnsignedShortLE(int i) {
        return this.source.getUnsignedShortLE(i);
    }

    public int getMedium(int i) {
        return this.source.getMedium(i);
    }

    public int getMediumLE(int i) {
        return this.source.getMediumLE(i);
    }

    public int getUnsignedMedium(int i) {
        return this.source.getUnsignedMedium(i);
    }

    public int getUnsignedMediumLE(int i) {
        return this.source.getUnsignedMediumLE(i);
    }

    public int getInt(int i) {
        return this.source.getInt(i);
    }

    public int getIntLE(int i) {
        return this.source.getIntLE(i);
    }

    public long getUnsignedInt(int i) {
        return this.source.getUnsignedInt(i);
    }

    public long getUnsignedIntLE(int i) {
        return this.source.getUnsignedIntLE(i);
    }

    public long getLong(int i) {
        return this.source.getLong(i);
    }

    public long getLongLE(int i) {
        return this.source.getLongLE(i);
    }

    public char getChar(int i) {
        return this.source.getChar(i);
    }

    public float getFloat(int i) {
        return this.source.getFloat(i);
    }

    public double getDouble(int i) {
        return this.source.getDouble(i);
    }

    public ByteBuf getBytes(int i, ByteBuf bytebuf) {
        return this.source.getBytes(i, bytebuf);
    }

    public ByteBuf getBytes(int i, ByteBuf bytebuf, int j) {
        return this.source.getBytes(i, bytebuf, j);
    }

    public ByteBuf getBytes(int i, ByteBuf bytebuf, int j, int k) {
        return this.source.getBytes(i, bytebuf, j, k);
    }

    public ByteBuf getBytes(int i, byte[] bytes) {
        return this.source.getBytes(i, bytes);
    }

    public ByteBuf getBytes(int i, byte[] bytes, int j, int k) {
        return this.source.getBytes(i, bytes, j, k);
    }

    public ByteBuf getBytes(int i, ByteBuffer bytebuffer) {
        return this.source.getBytes(i, bytebuffer);
    }

    public ByteBuf getBytes(int i, OutputStream outputstream, int j) throws IOException {
        return this.source.getBytes(i, outputstream, j);
    }

    public int getBytes(int i, GatheringByteChannel gatheringbytechannel, int j) throws IOException {
        return this.source.getBytes(i, gatheringbytechannel, j);
    }

    public int getBytes(int i, FileChannel filechannel, long j, int k) throws IOException {
        return this.source.getBytes(i, filechannel, j, k);
    }

    public CharSequence getCharSequence(int i, int j, Charset charset) {
        return this.source.getCharSequence(i, j, charset);
    }

    public ByteBuf setBoolean(int i, boolean flag) {
        return this.source.setBoolean(i, flag);
    }

    public ByteBuf setByte(int i, int j) {
        return this.source.setByte(i, j);
    }

    public ByteBuf setShort(int i, int j) {
        return this.source.setShort(i, j);
    }

    public ByteBuf setShortLE(int i, int j) {
        return this.source.setShortLE(i, j);
    }

    public ByteBuf setMedium(int i, int j) {
        return this.source.setMedium(i, j);
    }

    public ByteBuf setMediumLE(int i, int j) {
        return this.source.setMediumLE(i, j);
    }

    public ByteBuf setInt(int i, int j) {
        return this.source.setInt(i, j);
    }

    public ByteBuf setIntLE(int i, int j) {
        return this.source.setIntLE(i, j);
    }

    public ByteBuf setLong(int i, long j) {
        return this.source.setLong(i, j);
    }

    public ByteBuf setLongLE(int i, long j) {
        return this.source.setLongLE(i, j);
    }

    public ByteBuf setChar(int i, int j) {
        return this.source.setChar(i, j);
    }

    public ByteBuf setFloat(int i, float f) {
        return this.source.setFloat(i, f);
    }

    public ByteBuf setDouble(int i, double d0) {
        return this.source.setDouble(i, d0);
    }

    public ByteBuf setBytes(int i, ByteBuf bytebuf) {
        return this.source.setBytes(i, bytebuf);
    }

    public ByteBuf setBytes(int i, ByteBuf bytebuf, int j) {
        return this.source.setBytes(i, bytebuf, j);
    }

    public ByteBuf setBytes(int i, ByteBuf bytebuf, int j, int k) {
        return this.source.setBytes(i, bytebuf, j, k);
    }

    public ByteBuf setBytes(int i, byte[] bytes) {
        return this.source.setBytes(i, bytes);
    }

    public ByteBuf setBytes(int i, byte[] bytes, int j, int k) {
        return this.source.setBytes(i, bytes, j, k);
    }

    public ByteBuf setBytes(int i, ByteBuffer bytebuffer) {
        return this.source.setBytes(i, bytebuffer);
    }

    public int setBytes(int i, InputStream inputstream, int j) throws IOException {
        return this.source.setBytes(i, inputstream, j);
    }

    public int setBytes(int i, ScatteringByteChannel scatteringbytechannel, int j) throws IOException {
        return this.source.setBytes(i, scatteringbytechannel, j);
    }

    public int setBytes(int i, FileChannel filechannel, long j, int k) throws IOException {
        return this.source.setBytes(i, filechannel, j, k);
    }

    public ByteBuf setZero(int i, int j) {
        return this.source.setZero(i, j);
    }

    public int setCharSequence(int i, CharSequence charsequence, Charset charset) {
        return this.source.setCharSequence(i, charsequence, charset);
    }

    public boolean readBoolean() {
        return this.source.readBoolean();
    }

    public byte readByte() {
        return this.source.readByte();
    }

    public short readUnsignedByte() {
        return this.source.readUnsignedByte();
    }

    public short readShort() {
        return this.source.readShort();
    }

    public short readShortLE() {
        return this.source.readShortLE();
    }

    public int readUnsignedShort() {
        return this.source.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.source.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.source.readMedium();
    }

    public int readMediumLE() {
        return this.source.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.source.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.source.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.source.readInt();
    }

    public int readIntLE() {
        return this.source.readIntLE();
    }

    public long readUnsignedInt() {
        return this.source.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.source.readUnsignedIntLE();
    }

    public long readLong() {
        return this.source.readLong();
    }

    public long readLongLE() {
        return this.source.readLongLE();
    }

    public char readChar() {
        return this.source.readChar();
    }

    public float readFloat() {
        return this.source.readFloat();
    }

    public double readDouble() {
        return this.source.readDouble();
    }

    public ByteBuf readBytes(int i) {
        return this.source.readBytes(i);
    }

    public ByteBuf readSlice(int i) {
        return this.source.readSlice(i);
    }

    public ByteBuf readRetainedSlice(int i) {
        return this.source.readRetainedSlice(i);
    }

    public ByteBuf readBytes(ByteBuf bytebuf) {
        return this.source.readBytes(bytebuf);
    }

    public ByteBuf readBytes(ByteBuf bytebuf, int i) {
        return this.source.readBytes(bytebuf, i);
    }

    public ByteBuf readBytes(ByteBuf bytebuf, int i, int j) {
        return this.source.readBytes(bytebuf, i, j);
    }

    public ByteBuf readBytes(byte[] bytes) {
        return this.source.readBytes(bytes);
    }

    public ByteBuf readBytes(byte[] bytes, int i, int j) {
        return this.source.readBytes(bytes, i, j);
    }

    public ByteBuf readBytes(ByteBuffer bytebuffer) {
        return this.source.readBytes(bytebuffer);
    }

    public ByteBuf readBytes(OutputStream outputstream, int i) throws IOException {
        return this.source.readBytes(outputstream, i);
    }

    public int readBytes(GatheringByteChannel gatheringbytechannel, int i) throws IOException {
        return this.source.readBytes(gatheringbytechannel, i);
    }

    public CharSequence readCharSequence(int i, Charset charset) {
        return this.source.readCharSequence(i, charset);
    }

    public int readBytes(FileChannel filechannel, long i, int j) throws IOException {
        return this.source.readBytes(filechannel, i, j);
    }

    public ByteBuf skipBytes(int i) {
        return this.source.skipBytes(i);
    }

    public ByteBuf writeBoolean(boolean flag) {
        return this.source.writeBoolean(flag);
    }

    public ByteBuf writeByte(int i) {
        return this.source.writeByte(i);
    }

    public ByteBuf writeShort(int i) {
        return this.source.writeShort(i);
    }

    public ByteBuf writeShortLE(int i) {
        return this.source.writeShortLE(i);
    }

    public ByteBuf writeMedium(int i) {
        return this.source.writeMedium(i);
    }

    public ByteBuf writeMediumLE(int i) {
        return this.source.writeMediumLE(i);
    }

    public ByteBuf writeInt(int i) {
        return this.source.writeInt(i);
    }

    public ByteBuf writeIntLE(int i) {
        return this.source.writeIntLE(i);
    }

    public ByteBuf writeLong(long i) {
        return this.source.writeLong(i);
    }

    public ByteBuf writeLongLE(long i) {
        return this.source.writeLongLE(i);
    }

    public ByteBuf writeChar(int i) {
        return this.source.writeChar(i);
    }

    public ByteBuf writeFloat(float f) {
        return this.source.writeFloat(f);
    }

    public ByteBuf writeDouble(double d0) {
        return this.source.writeDouble(d0);
    }

    public ByteBuf writeBytes(ByteBuf bytebuf) {
        return this.source.writeBytes(bytebuf);
    }

    public ByteBuf writeBytes(ByteBuf bytebuf, int i) {
        return this.source.writeBytes(bytebuf, i);
    }

    public ByteBuf writeBytes(ByteBuf bytebuf, int i, int j) {
        return this.source.writeBytes(bytebuf, i, j);
    }

    public ByteBuf writeBytes(byte[] bytes) {
        return this.source.writeBytes(bytes);
    }

    public ByteBuf writeBytes(byte[] bytes, int i, int j) {
        return this.source.writeBytes(bytes, i, j);
    }

    public ByteBuf writeBytes(ByteBuffer bytebuffer) {
        return this.source.writeBytes(bytebuffer);
    }

    public int writeBytes(InputStream inputstream, int i) throws IOException {
        return this.source.writeBytes(inputstream, i);
    }

    public int writeBytes(ScatteringByteChannel scatteringbytechannel, int i) throws IOException {
        return this.source.writeBytes(scatteringbytechannel, i);
    }

    public int writeBytes(FileChannel filechannel, long i, int j) throws IOException {
        return this.source.writeBytes(filechannel, i, j);
    }

    public ByteBuf writeZero(int i) {
        return this.source.writeZero(i);
    }

    public int writeCharSequence(CharSequence charsequence, Charset charset) {
        return this.source.writeCharSequence(charsequence, charset);
    }

    public int indexOf(int i, int j, byte b) {
        return this.source.indexOf(i, j, b);
    }

    public int bytesBefore(byte b) {
        return this.source.bytesBefore(b);
    }

    public int bytesBefore(int i, byte b) {
        return this.source.bytesBefore(i, b);
    }

    public int bytesBefore(int i, int j, byte b) {
        return this.source.bytesBefore(i, j, b);
    }

    public int forEachByte(ByteProcessor byteprocessor) {
        return this.source.forEachByte(byteprocessor);
    }

    public int forEachByte(int i, int j, ByteProcessor byteprocessor) {
        return this.source.forEachByte(i, j, byteprocessor);
    }

    public int forEachByteDesc(ByteProcessor byteprocessor) {
        return this.source.forEachByteDesc(byteprocessor);
    }

    public int forEachByteDesc(int i, int j, ByteProcessor byteprocessor) {
        return this.source.forEachByteDesc(i, j, byteprocessor);
    }

    public ByteBuf copy() {
        return this.source.copy();
    }

    public ByteBuf copy(int i, int j) {
        return this.source.copy(i, j);
    }

    public ByteBuf slice() {
        return this.source.slice();
    }

    public ByteBuf retainedSlice() {
        return this.source.retainedSlice();
    }

    public ByteBuf slice(int i, int j) {
        return this.source.slice(i, j);
    }

    public ByteBuf retainedSlice(int i, int j) {
        return this.source.retainedSlice(i, j);
    }

    public ByteBuf duplicate() {
        return this.source.duplicate();
    }

    public ByteBuf retainedDuplicate() {
        return this.source.retainedDuplicate();
    }

    public int nioBufferCount() {
        return this.source.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.source.nioBuffer();
    }

    public ByteBuffer nioBuffer(int i, int j) {
        return this.source.nioBuffer(i, j);
    }

    public ByteBuffer internalNioBuffer(int i, int j) {
        return this.source.internalNioBuffer(i, j);
    }

    public ByteBuffer[] nioBuffers() {
        return this.source.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int i, int j) {
        return this.source.nioBuffers(i, j);
    }

    public boolean hasArray() {
        return this.source.hasArray();
    }

    public byte[] array() {
        return this.source.array();
    }

    public int arrayOffset() {
        return this.source.arrayOffset();
    }

    public boolean hasMemoryAddress() {
        return this.source.hasMemoryAddress();
    }

    public long memoryAddress() {
        return this.source.memoryAddress();
    }

    public String toString(Charset charset) {
        return this.source.toString(charset);
    }

    @NotNull
    public String toString(int i, int j, Charset charset) {
        return this.source.toString(i, j, charset);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FriendlyByteBuf)) {
            return false;
        }
        FriendlyByteBuf friendlyByteBuf = (FriendlyByteBuf)((Object)object);
        return this.source.equals((Object)friendlyByteBuf.source);
    }

    public int compareTo(ByteBuf bytebuf) {
        return this.source.compareTo(bytebuf);
    }

    public String toString() {
        return this.source.toString();
    }

    public ByteBuf retain(int i) {
        return this.source.retain(i);
    }

    public ByteBuf retain() {
        return this.source.retain();
    }

    public ByteBuf touch() {
        return this.source.touch();
    }

    public ByteBuf touch(Object object) {
        return this.source.touch(object);
    }

    public int refCnt() {
        return this.source.refCnt();
    }

    public boolean release() {
        return this.source.release();
    }

    public boolean release(int i) {
        return this.source.release(i);
    }

    @FunctionalInterface
    public static interface Reader<T>
    extends Function<FriendlyByteBuf, T> {
        default public Reader<Optional<T>> asOptional() {
            return buf -> buf.readOptional(this);
        }
    }

    @FunctionalInterface
    public static interface Writer<T>
    extends BiConsumer<FriendlyByteBuf, T> {
        default public Writer<Optional<T>> asOptional() {
            return (buf, optional) -> buf.writeOptional(optional, this);
        }
    }
}

