/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class GsonHelper {
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    public Gson getGson() {
        return this.gson;
    }

    public static Gson get() {
        return SingletonHolder.INSTANCE.getGson();
    }

    public static void writeJsonFile(JsonElement json, Path path) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            GsonHelper.get().toJson(json, (Appendable)writer);
        }
    }

    public static JsonElement readJsonFile(Path path) throws IOException, JsonParseException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            return jsonElement;
        }
    }

    public static JsonObject shallowMerge(JsonObject obj1, JsonObject obj2) {
        JsonObject merged = new JsonObject();
        for (Map.Entry entry : obj1.entrySet()) {
            merged.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        for (Map.Entry entry : obj2.entrySet()) {
            merged.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return merged;
    }

    public static JsonObject deepMerge(JsonObject source, JsonObject target) {
        JsonObject merged = new JsonObject();
        for (Map.Entry entry : source.entrySet()) {
            merged.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        for (Map.Entry entry : target.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (merged.has(key)) {
                JsonElement existingValue = merged.get(key);
                if (existingValue.isJsonObject() && value.isJsonObject()) {
                    JsonObject mergedChild = GsonHelper.deepMerge(existingValue.getAsJsonObject(), value.getAsJsonObject());
                    merged.add(key, (JsonElement)mergedChild);
                    continue;
                }
                merged.add(key, value);
                continue;
            }
            merged.add(key, value);
        }
        return merged;
    }

    public static JsonObject parseJsonToJsonObject(String json) {
        try {
            return (JsonObject)GsonHelper.get().fromJson(json, JsonObject.class);
        }
        catch (JsonSyntaxException e) {
            throw new RuntimeException("Invalid JSON response: " + json, e);
        }
    }

    public static Map<String, Object> parseJsonToMap(String json) {
        try {
            return (Map)GsonHelper.get().fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            throw new RuntimeException("Invalid JSON response: " + json, e);
        }
    }

    public static JsonElement combine(List<? extends JsonElement> jo) {
        if (jo.size() == 1) {
            return jo.get(0);
        }
        JsonArray ja = new JsonArray();
        for (JsonElement jsonElement : jo) {
            ja.add(jsonElement);
        }
        return ja;
    }

    private static class SingletonHolder {
        private static final GsonHelper INSTANCE = new GsonHelper();

        private SingletonHolder() {
        }
    }
}

