/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import com.google.common.collect.MapMaker;
import java.util.Map;
import net.momirealms.craftengine.core.util.Key;

public class ResourceKey<T> {
    private static final Map<Internal, ResourceKey<?>> VALUES = new MapMaker().weakValues().makeMap();
    private final Key registry;
    private final Key location;

    private ResourceKey(Key registry, Key location) {
        this.registry = registry;
        this.location = location;
    }

    public static <T> ResourceKey<T> create(Key registry, Key location) {
        return VALUES.computeIfAbsent(new Internal(registry, location), key -> new ResourceKey(key.registry, key.location));
    }

    public Key registry() {
        return this.registry;
    }

    public Key location() {
        return this.location;
    }

    public String toString() {
        return "ResourceKey[" + String.valueOf(this.registry) + " / " + String.valueOf(this.location) + "]";
    }

    record Internal(Key registry, Key location) {
    }
}

