/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.momirealms.craftengine.core.world.ChunkPos;
import net.momirealms.craftengine.core.world.SectionPos;

public class SectionPosUtils {
    private SectionPosUtils() {
    }

    public static Map<Long, BitSet> nearbySectionsMap(Set<SectionPos> sections, int minLightSection, int maxLightSection) {
        Long2ObjectOpenHashMap nearby = new Long2ObjectOpenHashMap();
        for (SectionPos section : sections) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    long chunkPos = ChunkPos.asLong(section.x() + i, section.z() + j);
                    BitSet posSet = nearby.computeIfAbsent(chunkPos, k -> new BitSet(maxLightSection - minLightSection));
                    for (int k2 = -1; k2 <= 1; ++k2) {
                        int y = section.y() + k2;
                        if (y < minLightSection || y > maxLightSection) continue;
                        posSet.set(y - minLightSection);
                    }
                }
            }
        }
        return nearby;
    }

    public static Map<Long, BitSet> toMap(Set<SectionPos> sections, int minLightSection, int maxLightSection) {
        int nBits = maxLightSection - minLightSection;
        Long2ObjectOpenHashMap nearby = new Long2ObjectOpenHashMap(Math.max(8, sections.size() / 2), 0.5f);
        for (SectionPos section : sections) {
            long chunkPos = ChunkPos.asLong(section.x(), section.z());
            BitSet posSet = nearby.computeIfAbsent(chunkPos, k -> new BitSet(nBits));
            int y = section.y();
            if (y < minLightSection || y > maxLightSection) continue;
            posSet.set(y - minLightSection);
        }
        return nearby;
    }

    public static List<SectionPos> calculateAffectedRegions(int sx, int sy, int sz, int x) {
        ArrayList<SectionPos> regions = new ArrayList<SectionPos>();
        int rxStart = sx - x >> 4;
        int rxEnd = sx + x >> 4;
        int ryStart = sy - x >> 4;
        int ryEnd = sy + x >> 4;
        int rzStart = sz - x >> 4;
        int rzEnd = sz + x >> 4;
        for (int rx = rxStart; rx <= rxEnd; ++rx) {
            for (int ry = ryStart; ry <= ryEnd; ++ry) {
                for (int rz = rzStart; rz <= rzEnd; ++rz) {
                    int zMax;
                    int zMin;
                    int dzMin;
                    int yMax;
                    int yMin;
                    int dyMin;
                    int xMin = rx << 4;
                    int xMax = xMin + 15;
                    int dxMin = SectionPosUtils.calculateMinDistance(sx, xMin, xMax);
                    if (dxMin + (dyMin = SectionPosUtils.calculateMinDistance(sy, yMin = ry << 4, yMax = yMin + 15)) + (dzMin = SectionPosUtils.calculateMinDistance(sz, zMin = rz << 4, zMax = zMin + 15)) > x) continue;
                    regions.add(new SectionPos(rx, ry, rz));
                }
            }
        }
        return regions;
    }

    private static int calculateMinDistance(int coord, int min, int max) {
        if (coord < min) {
            return min - coord;
        }
        if (coord > max) {
            return coord - max;
        }
        return 0;
    }
}

