/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.world;

import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.SectionPos;

public interface WorldHeight {
    public int getHeight();

    public int getMinBuildHeight();

    default public int getMaxBuildHeight() {
        return this.getMinBuildHeight() + this.getHeight();
    }

    default public int getSectionsCount() {
        return this.getMaxSection() - this.getMinSection();
    }

    default public int getMinSection() {
        return SectionPos.blockToSectionCoord(this.getMinBuildHeight());
    }

    default public int getMaxSection() {
        return SectionPos.blockToSectionCoord(this.getMaxBuildHeight() - 1) + 1;
    }

    default public boolean isOutsideBuildHeight(BlockPos pos) {
        return this.isOutsideBuildHeight(pos.y());
    }

    default public boolean isOutsideBuildHeight(int y) {
        return y < this.getMinBuildHeight() || y >= this.getMaxBuildHeight();
    }

    default public int getSectionIndex(int y) {
        return this.getSectionIndexFromSectionY(SectionPos.blockToSectionCoord(y));
    }

    default public int getSectionIndexFromSectionY(int coord) {
        return coord - this.getMinSection();
    }

    default public int getSectionYFromSectionIndex(int index) {
        return index + this.getMinSection();
    }

    public static WorldHeight create(int bottomY, int height) {
        return new WorldHeightImpl(bottomY, height);
    }

    public static class WorldHeightImpl
    implements WorldHeight {
        private final int bottomY;
        private final int height;
        private final int minSection;

        public WorldHeightImpl(int bottomY, int height) {
            this.bottomY = bottomY;
            this.height = height;
            this.minSection = SectionPos.blockToSectionCoord(this.getMinBuildHeight());
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public int getMinBuildHeight() {
            return this.bottomY;
        }

        @Override
        public int getMinSection() {
            return this.minSection;
        }
    }
}

