/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.antigrieflib;

import java.util.HashSet;
import java.util.Set;
import net.momirealms.craftengine.libraries.antigrieflib.AntiGriefPlugin;
import net.momirealms.craftengine.libraries.antigrieflib.CompatibilityException;
import net.momirealms.craftengine.libraries.antigrieflib.comp.BentoBoxComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.CrashClaimComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.DominionComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.FabledSkyBlockComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.FactionsUUIDComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.GriefDefenderComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.GriefPreventionComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.HClaimsComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.HuskClaimsComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.HuskTownsComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.IridiumSkyblockComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.KingdomsComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.LandlordComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.LandsComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.NoBuildPlusComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.PlotSquaredV5Comp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.PlotSquaredV6V7Comp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.PreciousStonesComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.RedProtectComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.ResidenceComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.SaberFactionsComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.SuperiorSkyblockComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.TownyComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.USkyBlockComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.UltimateClaimsComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.UltimateClansComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.WorldGuardComp;
import net.momirealms.craftengine.libraries.antigrieflib.comp.XClaimComp;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class AntiGriefLib {
    private final JavaPlugin plugin;
    private final Set<AntiGriefPlugin> plugins = new HashSet<AntiGriefPlugin>();
    private boolean ignoreOP;
    private boolean silentLogs;

    private AntiGriefLib(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    private void init() {
        for (AntiGriefPlugin antiGriefPlugin : this.plugins) {
            antiGriefPlugin.init();
            this.logHook(antiGriefPlugin.getAntiGriefPluginName());
        }
    }

    public static Builder builder(JavaPlugin plugin) {
        return new Builder(plugin);
    }

    public boolean canPlace(Player player, Location location) {
        if (this.ignoreOP && player.isOp()) {
            return true;
        }
        for (AntiGriefPlugin antiGriefPlugin : this.plugins) {
            if (antiGriefPlugin.canPlace(player, location)) continue;
            return false;
        }
        return true;
    }

    public boolean canBreak(Player player, Location location) {
        if (this.ignoreOP && player.isOp()) {
            return true;
        }
        for (AntiGriefPlugin antiGriefPlugin : this.plugins) {
            if (antiGriefPlugin.canBreak(player, location)) continue;
            return false;
        }
        return true;
    }

    public boolean canInteract(Player player, Location location) {
        if (this.ignoreOP && player.isOp()) {
            return true;
        }
        for (AntiGriefPlugin antiGriefPlugin : this.plugins) {
            if (antiGriefPlugin.canInteract(player, location)) continue;
            return false;
        }
        return true;
    }

    public boolean canInteractEntity(Player player, Entity entity) {
        if (this.ignoreOP && player.isOp()) {
            return true;
        }
        for (AntiGriefPlugin antiGriefPlugin : this.plugins) {
            if (antiGriefPlugin.canInteractEntity(player, entity)) continue;
            return false;
        }
        return true;
    }

    public boolean canDamage(Player player, Entity entity) {
        Player another;
        if (entity instanceof Player && !(another = (Player)entity).getWorld().getPVP()) {
            return false;
        }
        if (this.ignoreOP && player.isOp()) {
            return true;
        }
        for (AntiGriefPlugin antiGriefPlugin : this.plugins) {
            if (antiGriefPlugin.canDamage(player, entity)) continue;
            return false;
        }
        return true;
    }

    public void registerNewCompatibility(AntiGriefPlugin antiGriefPlugin) {
        this.plugins.add(antiGriefPlugin);
    }

    private void detectSupportedPlugins() {
        PluginManager manager = Bukkit.getPluginManager();
        if (manager.getPlugin("WorldGuard") != null) {
            this.registerNewCompatibility(new WorldGuardComp(this.plugin));
        }
        if (manager.getPlugin("Kingdoms") != null) {
            this.registerNewCompatibility(new KingdomsComp(this.plugin));
        }
        if (manager.getPlugin("Lands") != null) {
            this.registerNewCompatibility(new LandsComp(this.plugin));
        }
        if (manager.getPlugin("IridiumSkyblock") != null && manager.getPlugin("IridiumSkyblock").getDescription().getVersion().startsWith("4.0")) {
            this.registerNewCompatibility(new IridiumSkyblockComp(this.plugin));
        }
        if (manager.getPlugin("CrashClaim") != null) {
            this.registerNewCompatibility(new CrashClaimComp(this.plugin));
        }
        if (manager.getPlugin("GriefDefender") != null) {
            this.registerNewCompatibility(new GriefDefenderComp(this.plugin));
        }
        if (manager.getPlugin("HuskClaims") != null) {
            this.registerNewCompatibility(new HuskClaimsComp(this.plugin));
        }
        if (manager.getPlugin("BentoBox") != null) {
            this.registerNewCompatibility(new BentoBoxComp(this.plugin));
        }
        if (manager.getPlugin("HuskTowns") != null) {
            this.registerNewCompatibility(new HuskTownsComp(this.plugin));
        }
        if (manager.getPlugin("PlotSquared") != null) {
            switch (manager.getPlugin("PlotSquared").getDescription().getVersion().charAt(0)) {
                case '5': {
                    this.registerNewCompatibility(new PlotSquaredV5Comp(this.plugin));
                    break;
                }
                case '6': 
                case '7': {
                    this.registerNewCompatibility(new PlotSquaredV6V7Comp(this.plugin));
                }
            }
        }
        if (manager.getPlugin("Residence") != null) {
            this.registerNewCompatibility(new ResidenceComp(this.plugin));
        }
        if (manager.getPlugin("SuperiorSkyblock2") != null) {
            this.registerNewCompatibility(new SuperiorSkyblockComp(this.plugin));
        }
        if (manager.getPlugin("Towny") != null) {
            this.registerNewCompatibility(new TownyComp(this.plugin));
        }
        if (manager.getPlugin("FabledSkyBlock") != null) {
            this.registerNewCompatibility(new FabledSkyBlockComp(this.plugin));
        }
        if (manager.getPlugin("GriefPrevention") != null) {
            this.registerNewCompatibility(new GriefPreventionComp(this.plugin));
        }
        if (manager.getPlugin("RedProtect") != null) {
            this.registerNewCompatibility(new RedProtectComp(this.plugin));
        }
        if (manager.getPlugin("Landlord") != null) {
            this.registerNewCompatibility(new LandlordComp(this.plugin));
        }
        if (manager.getPlugin("uSkyBlock") != null) {
            this.registerNewCompatibility(new USkyBlockComp(this.plugin));
        }
        if (manager.getPlugin("XClaim") != null) {
            this.registerNewCompatibility(new XClaimComp(this.plugin));
        }
        if (manager.getPlugin("UltimateClaims") != null) {
            this.registerNewCompatibility(new UltimateClaimsComp(this.plugin));
        }
        if (manager.getPlugin("UltimateClans") != null) {
            this.registerNewCompatibility(new UltimateClansComp(this.plugin));
        }
        if (manager.getPlugin("PreciousStones") != null) {
            this.registerNewCompatibility(new PreciousStonesComp(this.plugin));
        }
        if (manager.getPlugin("hClaims") != null) {
            this.registerNewCompatibility(new HClaimsComp(this.plugin));
        }
        if (manager.getPlugin("Dominion") != null) {
            this.registerNewCompatibility(new DominionComp(this.plugin));
        }
        if (manager.getPlugin("Factions") != null) {
            try {
                Class.forName("com.massivecraft.factions.zcore.fperms.PermissableAction");
                this.registerNewCompatibility(new SaberFactionsComp(this.plugin));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                Class.forName("com.massivecraft.factions.perms.PermissibleActions");
                this.registerNewCompatibility(new FactionsUUIDComp(this.plugin));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (manager.getPlugin("NoBuildPlus") != null) {
            this.registerNewCompatibility(new NoBuildPlusComp(this.plugin));
        }
    }

    private void logHook(String pluginName) {
        if (this.silentLogs) {
            return;
        }
        this.plugin.getLogger().info("[AntiGriefLib] Enabled " + pluginName + " compatibility.");
    }

    public static class Builder {
        private final AntiGriefLib lib;

        public Builder(JavaPlugin plugin) {
            this.lib = new AntiGriefLib(plugin);
            try {
                this.lib.detectSupportedPlugins();
            }
            catch (Exception e) {
                throw new CompatibilityException("AntiGriefLib failed to init", e);
            }
        }

        public Builder ignoreOP(boolean ignoreOP) {
            this.lib.ignoreOP = ignoreOP;
            return this;
        }

        public Builder silentLogs(boolean silent) {
            this.lib.silentLogs = silent;
            return this;
        }

        public Builder addCompatibility(AntiGriefPlugin antiGriefPlugin) {
            this.lib.registerNewCompatibility(antiGriefPlugin);
            return this;
        }

        public AntiGriefLib build() {
            this.lib.init();
            return this.lib;
        }
    }
}

