/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.antigrieflib.comp;

import java.util.Optional;
import net.momirealms.craftengine.libraries.antigrieflib.AbstractComp;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;

public class KingdomsComp
extends AbstractComp {
    public KingdomsComp(JavaPlugin plugin) {
        super(plugin, "Kingdoms");
    }

    @Override
    public void init() {
    }

    @Override
    public boolean canPlace(Player player, Location location) {
        return this.kingdomsMemberCheck(player, location);
    }

    @Override
    public boolean canBreak(Player player, Location location) {
        return this.kingdomsMemberCheck(player, location);
    }

    @Override
    public boolean canInteract(Player player, Location location) {
        return this.kingdomsMemberCheck(player, location);
    }

    @Override
    public boolean canInteractEntity(Player player, Entity entity) {
        return this.kingdomsMemberCheck(player, entity.getLocation());
    }

    @Override
    public boolean canDamage(Player player, Entity entity) {
        return this.kingdomsMemberCheck(player, entity.getLocation());
    }

    private boolean kingdomsMemberCheck(Player player, Location location) {
        Land land = Land.getLand((Location)location);
        if (land == null || !land.isClaimed()) {
            return true;
        }
        return Optional.ofNullable(land.getKingdom()).map(kingdom -> KingdomPlayer.getKingdomPlayer((OfflinePlayer)player).getKingdom() == kingdom).orElse(true);
    }
}

