/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.momirealms.craftengine.libraries.nbt.ByteArrayTag;
import net.momirealms.craftengine.libraries.nbt.ByteTag;
import net.momirealms.craftengine.libraries.nbt.DoubleTag;
import net.momirealms.craftengine.libraries.nbt.FloatTag;
import net.momirealms.craftengine.libraries.nbt.IntArrayTag;
import net.momirealms.craftengine.libraries.nbt.IntTag;
import net.momirealms.craftengine.libraries.nbt.ListTag;
import net.momirealms.craftengine.libraries.nbt.LongArrayTag;
import net.momirealms.craftengine.libraries.nbt.LongTag;
import net.momirealms.craftengine.libraries.nbt.NBT;
import net.momirealms.craftengine.libraries.nbt.NumericTag;
import net.momirealms.craftengine.libraries.nbt.ShortTag;
import net.momirealms.craftengine.libraries.nbt.StringTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import net.momirealms.craftengine.libraries.nbt.TagType;
import net.momirealms.craftengine.libraries.nbt.TagTypes;
import net.momirealms.craftengine.libraries.nbt.TagVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundTag
implements Tag {
    public final Map<String, Tag> tags;

    public CompoundTag(Map<String, Tag> tags) {
        this.tags = tags;
    }

    public CompoundTag() {
        this.tags = new HashMap<String, Tag>(8, 0.8f);
    }

    public int size() {
        return this.tags.size();
    }

    @NotNull
    public Set<String> keySet() {
        return this.tags.keySet();
    }

    @NotNull
    public Set<Map.Entry<String, Tag>> entrySet() {
        return this.tags.entrySet();
    }

    @Nullable
    public Tag put(@NotNull String key, Tag element) {
        return this.tags.put(key, element);
    }

    public void putByte(@NotNull String key, byte value) {
        this.tags.put(key, new ByteTag(value));
    }

    public void putBoolean(@NotNull String key, boolean value) {
        this.tags.put(key, new ByteTag(value));
    }

    public void putShort(@NotNull String key, short value) {
        this.tags.put(key, new ShortTag(value));
    }

    public void putInt(@NotNull String key, int value) {
        this.tags.put(key, new IntTag(value));
    }

    public void putLong(@NotNull String key, long value) {
        this.tags.put(key, new LongTag(value));
    }

    public void putFloat(@NotNull String key, float value) {
        this.tags.put(key, new FloatTag(value));
    }

    public void putDouble(@NotNull String key, double value) {
        this.tags.put(key, new DoubleTag(value));
    }

    public void putString(@NotNull String key, @NotNull String value) {
        this.tags.put(key, new StringTag(value));
    }

    public void putByteArray(@NotNull String key, byte @NotNull [] value) {
        this.tags.put(key, new ByteArrayTag(value));
    }

    public void putLongArray(@NotNull String key, long @NotNull [] value) {
        this.tags.put(key, new LongArrayTag(value));
    }

    public void putIntArray(@NotNull String key, int @NotNull [] value) {
        this.tags.put(key, new IntArrayTag(value));
    }

    public void putUUID(@NotNull String key, @NotNull UUID value) {
        this.tags.put(key, NBT.createUUID(value));
    }

    @Nullable
    public Tag get(@NotNull String key) {
        return this.tags.get(key);
    }

    public boolean getBoolean(@NotNull String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(@NotNull String key, boolean defaultValue) {
        return this.getByte(key, (byte)(defaultValue ? 1 : 0)) != 0;
    }

    public byte getByte(@NotNull String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(@NotNull String key, byte defaultValue) {
        return this.getOrDefault(key, 99, t -> ((NumericTag)t).getAsByte(), defaultValue);
    }

    public short getShort(@NotNull String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(@NotNull String key, short defaultValue) {
        return this.getOrDefault(key, 99, t -> ((NumericTag)t).getAsShort(), defaultValue);
    }

    public int getInt(@NotNull String key) {
        return this.getInt(key, 0);
    }

    public int getInt(@NotNull String key, int defaultValue) {
        return this.getOrDefault(key, 99, t -> ((NumericTag)t).getAsInt(), defaultValue);
    }

    public long getLong(@NotNull String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(@NotNull String key, long defaultValue) {
        return this.getOrDefault(key, 99, t -> ((NumericTag)t).getAsLong(), defaultValue);
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(@NotNull String key, float defaultValue) {
        return this.getOrDefault(key, 99, t -> Float.valueOf(((NumericTag)t).getAsFloat()), Float.valueOf(defaultValue)).floatValue();
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(@NotNull String key, double defaultValue) {
        return this.getOrDefault(key, 99, t -> ((NumericTag)t).getAsDouble(), defaultValue);
    }

    public String getString(@NotNull String key) {
        return this.getString(key, null);
    }

    public String getString(@NotNull String key, String defaultValue) {
        return this.getOrDefault(key, 8, Tag::getAsString, defaultValue);
    }

    public byte[] getByteArray(String key) {
        return this.getByteArray(key, null);
    }

    public byte[] getByteArray(@NotNull String key, byte[] defaultValue) {
        return this.getOrDefault(key, 7, t -> ((ByteArrayTag)t).getAsByteArray(), defaultValue);
    }

    public int[] getIntArray(String key) {
        return this.getIntArray(key, null);
    }

    public int[] getIntArray(@NotNull String key, int[] defaultValue) {
        return this.getOrDefault(key, 11, t -> ((IntArrayTag)t).getAsIntArray(), defaultValue);
    }

    public UUID getUUID(String key) {
        return this.getUUID(key, null);
    }

    public UUID getUUID(@NotNull String key, UUID defaultValue) {
        return this.getOrDefault(key, 11, t -> ((IntArrayTag)t).getAsUUID(), defaultValue);
    }

    public long[] getLongArray(String key) {
        return this.getLongArray(key, null);
    }

    public long[] getLongArray(@NotNull String key, long[] defaultValue) {
        return this.getOrDefault(key, 12, t -> ((LongArrayTag)t).getAsLongArray(), defaultValue);
    }

    public CompoundTag getCompound(String key) {
        return this.getCompound(key, null);
    }

    public CompoundTag getCompound(@NotNull String key, CompoundTag defaultValue) {
        return this.getOrDefault(key, 10, t -> (CompoundTag)t, defaultValue);
    }

    public ListTag getList(String key) {
        return this.getList(key, null);
    }

    public ListTag getList(@NotNull String key, ListTag defaultValue) {
        return this.getOrDefault(key, 9, t -> (ListTag)t, defaultValue);
    }

    private <T> T getOrDefault(@NotNull String key, int expectedType, @NotNull Function<Tag, T> extractor, T defaultValue) {
        Tag tag = this.tags.get(key);
        return tag != null && tag.isTypeOf(expectedType) ? extractor.apply(tag) : defaultValue;
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    public void remove(String key) {
        this.tags.remove(key);
    }

    public boolean containsKey(String key) {
        return this.tags.containsKey(key);
    }

    public byte getTagType(String key) {
        Tag tag = this.tags.get(key);
        return tag == null ? (byte)0 : tag.getId();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
            CompoundTag.writeNamedTag(entry.getKey(), entry.getValue(), output);
        }
        output.writeByte(0);
    }

    private static void writeNamedTag(String key, Tag element, DataOutput output) throws IOException {
        output.writeByte(element.getId());
        if (element.getId() != 0) {
            output.writeUTF(key);
            element.write(output);
        }
    }

    @Override
    public byte getId() {
        return 10;
    }

    @Override
    public TagType<?> getType() {
        return TagTypes.COMPOUND;
    }

    @Override
    public CompoundTag copy() {
        HashMap<String, Tag> newTags = new HashMap<String, Tag>(this.tags.size(), 0.8f);
        for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
            newTags.put(entry.getKey(), entry.getValue().copy());
        }
        return new CompoundTag(newTags);
    }

    @Override
    public CompoundTag deepClone() {
        HashMap<String, Tag> newTags = new HashMap<String, Tag>(this.tags.size(), 0.8f);
        for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
            newTags.put(entry.getKey(), entry.getValue().deepClone());
        }
        return new CompoundTag(newTags);
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitCompound(this);
    }

    static byte readNamedTagType(DataInput input) throws IOException {
        return input.readByte();
    }

    static String readNamedTagName(DataInput input) throws IOException {
        return input.readUTF();
    }

    static Tag readNamedTagData(TagType<?> reader, DataInput input, int depth) {
        try {
            return reader.read(input, depth);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompoundTag)) {
            return false;
        }
        CompoundTag that = (CompoundTag)o;
        return Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return this.tags.hashCode();
    }

    @Override
    public String toString() {
        return this.getAsString();
    }
}

