/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt;

import java.io.DataOutput;
import java.io.IOException;
import net.momirealms.craftengine.libraries.nbt.NumericTag;
import net.momirealms.craftengine.libraries.nbt.TagType;
import net.momirealms.craftengine.libraries.nbt.TagTypes;
import net.momirealms.craftengine.libraries.nbt.TagVisitor;
import net.momirealms.craftengine.libraries.nbt.util.MathUtil;

public class DoubleTag
extends NumericTag {
    private final double value;

    public DoubleTag(double value) {
        this.value = value;
    }

    @Override
    public long getAsLong() {
        return (long)Math.floor(this.value);
    }

    @Override
    public int getAsInt() {
        return MathUtil.fastFloor(this.value);
    }

    @Override
    public short getAsShort() {
        return (short)(MathUtil.fastFloor(this.value) & 0xFFFF);
    }

    @Override
    public byte getAsByte() {
        return (byte)(MathUtil.fastFloor(this.value) & 0xFF);
    }

    @Override
    public double getAsDouble() {
        return this.value;
    }

    @Override
    public float getAsFloat() {
        return (float)this.value;
    }

    @Override
    public Number getAsNumber() {
        return this.value;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeDouble(this.value);
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    public TagType<?> getType() {
        return TagTypes.DOUBLE;
    }

    @Override
    public DoubleTag deepClone() {
        return new DoubleTag(this.value);
    }

    @Override
    public DoubleTag copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitDouble(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleTag)) {
            return false;
        }
        DoubleTag doubleTag = (DoubleTag)o;
        return this.value == doubleTag.value;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }
}

