/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt.adventure;

import net.momirealms.craftengine.libraries.adventure.key.Key;
import net.momirealms.craftengine.libraries.adventure.text.event.ClickEvent;
import net.momirealms.craftengine.libraries.adventure.text.event.HoverEvent;
import net.momirealms.craftengine.libraries.adventure.text.format.NamedTextColor;
import net.momirealms.craftengine.libraries.adventure.text.format.ShadowColor;
import net.momirealms.craftengine.libraries.adventure.text.format.Style;
import net.momirealms.craftengine.libraries.adventure.text.format.TextColor;
import net.momirealms.craftengine.libraries.adventure.text.format.TextDecoration;
import net.momirealms.craftengine.libraries.adventure.util.ARGBLike;
import net.momirealms.craftengine.libraries.nbt.ByteTag;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.IntTag;
import net.momirealms.craftengine.libraries.nbt.ListTag;
import net.momirealms.craftengine.libraries.nbt.StringTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import net.momirealms.craftengine.libraries.nbt.adventure.NBTClickEventSerializer;
import net.momirealms.craftengine.libraries.nbt.adventure.NBTComponentSerializerImpl;
import net.momirealms.craftengine.libraries.nbt.adventure.NBTHoverEventSerializer;
import org.jetbrains.annotations.NotNull;

class NBTStyleSerializer {
    private static final String COLOR = "color";
    private static final String BOLD = "bold";
    private static final String ITALIC = "italic";
    private static final String UNDERLINED = "underlined";
    private static final String STRIKETHROUGH = "strikethrough";
    private static final String OBFUSCATED = "obfuscated";
    private static final String FONT = "font";
    private static final String INSERTION = "insertion";
    private static final String SHADOW_COLOR = "shadow_color";
    private static final String LEGACY_CLICK_EVENT = "clickEvent";
    private static final String CLICK_EVENT = "click_event";
    private static final String LEGACY_HOVER_EVENT = "hoverEvent";
    private static final String HOVER_EVENT = "hover_event";

    private NBTStyleSerializer() {
    }

    @NotNull
    static Style deserialize(@NotNull CompoundTag compound, @NotNull NBTComponentSerializerImpl serializer) {
        Tag binaryShadewColor;
        Tag binaryInsertion;
        String hoverEvent;
        Tag binaryHoverEvent;
        String clickEvent;
        Tag binaryClickEvent;
        Style.Builder styleBuilder = Style.style();
        String colorString = compound.getString(COLOR);
        if (colorString != null) {
            if (colorString.startsWith("#")) {
                styleBuilder.color(TextColor.fromHexString((String)colorString));
            } else {
                styleBuilder.color((TextColor)NamedTextColor.NAMES.value((Object)colorString));
            }
        }
        styleBuilder.decoration(TextDecoration.BOLD, NBTStyleSerializer.readOptionalState(BOLD, compound)).decoration(TextDecoration.ITALIC, NBTStyleSerializer.readOptionalState(ITALIC, compound)).decoration(TextDecoration.UNDERLINED, NBTStyleSerializer.readOptionalState(UNDERLINED, compound)).decoration(TextDecoration.STRIKETHROUGH, NBTStyleSerializer.readOptionalState(STRIKETHROUGH, compound)).decoration(TextDecoration.OBFUSCATED, NBTStyleSerializer.readOptionalState(OBFUSCATED, compound));
        String fontString = compound.getString(FONT);
        if (fontString != null) {
            styleBuilder.font(Key.key((String)fontString));
        }
        if ((binaryClickEvent = compound.get(clickEvent = serializer.modernClickEvent ? CLICK_EVENT : LEGACY_CLICK_EVENT)) != null) {
            styleBuilder.clickEvent(NBTClickEventSerializer.deserialize((CompoundTag)binaryClickEvent, serializer));
        }
        if ((binaryHoverEvent = compound.get(hoverEvent = serializer.modernHoverEvent ? HOVER_EVENT : LEGACY_HOVER_EVENT)) != null) {
            styleBuilder.hoverEvent(NBTHoverEventSerializer.deserialize((CompoundTag)binaryHoverEvent, serializer));
        }
        if ((binaryInsertion = compound.get(INSERTION)) != null) {
            styleBuilder.insertion(((StringTag)binaryInsertion).getAsString());
        }
        if ((binaryShadewColor = compound.get(SHADOW_COLOR)) != null) {
            ListTag listTag;
            if (binaryShadewColor instanceof IntTag) {
                IntTag intTag = (IntTag)binaryShadewColor;
                styleBuilder.shadowColor((ARGBLike)ShadowColor.shadowColor((int)intTag.getAsInt()));
            } else if (binaryShadewColor instanceof ListTag && (listTag = (ListTag)binaryShadewColor).size() == 4) {
                int r = (int)listTag.getFloat(0) * 255;
                int g = (int)listTag.getFloat(1) * 255;
                int b2 = (int)listTag.getFloat(2) * 255;
                int a2 = (int)listTag.getFloat(3) * 255;
                styleBuilder.shadowColor((ARGBLike)ShadowColor.shadowColor((int)r, (int)g, (int)b2, (int)a2));
            }
        }
        return styleBuilder.build();
    }

    static void serialize(@NotNull Style style, CompoundTag tag, @NotNull NBTComponentSerializerImpl serializer) {
        ShadowColor shadowColor;
        HoverEvent hoverEvent;
        ClickEvent clickEvent;
        String insertion;
        TextColor color = style.color();
        if (color != null) {
            tag.putString(COLOR, color.toString());
        }
        style.decorations().forEach((decoration, state) -> {
            if (state != TextDecoration.State.NOT_SET) {
                tag.putBoolean(switch (decoration) {
                    case TextDecoration.OBFUSCATED -> OBFUSCATED;
                    case TextDecoration.BOLD -> BOLD;
                    case TextDecoration.STRIKETHROUGH -> STRIKETHROUGH;
                    case TextDecoration.UNDERLINED -> UNDERLINED;
                    case TextDecoration.ITALIC -> ITALIC;
                    default -> throw new IllegalStateException("Unknown text decoration: " + String.valueOf(decoration));
                }, state == TextDecoration.State.TRUE);
            }
        });
        Key font = style.font();
        if (font != null) {
            tag.putString(FONT, font.asString());
        }
        if ((insertion = style.insertion()) != null) {
            tag.putString(INSERTION, insertion);
        }
        if ((clickEvent = style.clickEvent()) != null) {
            tag.put(serializer.modernClickEvent ? CLICK_EVENT : LEGACY_CLICK_EVENT, NBTClickEventSerializer.serialize(clickEvent, serializer));
        }
        if ((hoverEvent = style.hoverEvent()) != null) {
            tag.put(serializer.modernHoverEvent ? HOVER_EVENT : LEGACY_HOVER_EVENT, NBTHoverEventSerializer.serialize(hoverEvent, serializer));
        }
        if ((shadowColor = style.shadowColor()) != null) {
            tag.put(SHADOW_COLOR, new IntTag(shadowColor.value()));
        }
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TextDecoration.State readOptionalState(@NotNull String key, @NotNull CompoundTag compound) {
        Tag tag = compound.get(key);
        if (!(tag instanceof ByteTag)) {
            return TextDecoration.State.NOT_SET;
        }
        ByteTag byteTag = (ByteTag)tag;
        return TextDecoration.State.byBoolean((boolean)byteTag.booleanValue());
    }
}

