/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.block;

import io.papermc.paper.event.block.BlockBreakBlockEvent;
import java.util.Optional;
import net.momirealms.craftengine.bukkit.api.BukkitAdaptors;
import net.momirealms.craftengine.bukkit.api.event.CustomBlockBreakEvent;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBlocks;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.EntityUtils;
import net.momirealms.craftengine.bukkit.util.EventUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.bukkit.util.NoteBlockChainUpdateUtils;
import net.momirealms.craftengine.bukkit.world.BukkitBlockInWorld;
import net.momirealms.craftengine.bukkit.world.BukkitWorld;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.entity.player.InteractionHand;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.loot.LootTable;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.util.Cancellable;
import net.momirealms.craftengine.core.util.ItemUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.core.world.WorldPosition;
import org.bukkit.GameEvent;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.world.GenericGameEvent;
import org.bukkit.inventory.ItemStack;

public final class BlockEventListener
implements Listener {
    private final BukkitCraftEngine plugin;
    private final boolean enableNoteBlockCheck;
    private final BukkitBlockManager manager;

    public BlockEventListener(BukkitCraftEngine plugin, BukkitBlockManager manager, boolean enableNoteBlockCheck) {
        this.plugin = plugin;
        this.manager = manager;
        this.enableNoteBlockCheck = enableNoteBlockCheck;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerAttack(EntityDamageByEntityEvent event) {
        Entity entity;
        if (!VersionHelper.isOrAbove1_20_5() && (entity = event.getDamager()) instanceof org.bukkit.entity.Player) {
            org.bukkit.entity.Player player = (org.bukkit.entity.Player)entity;
            BukkitServerPlayer serverPlayer = BukkitAdaptors.adapt(player);
            serverPlayer.setClientSideCanBreakBlock(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlaceBlock(BlockPlaceEvent event) {
        Object ownerBlock;
        Block block;
        Object blockState;
        org.bukkit.entity.Player player = event.getPlayer();
        BukkitServerPlayer serverPlayer = BukkitAdaptors.adapt(player);
        if (serverPlayer.shouldResendSwing()) {
            player.swingHand(event.getHand());
        }
        if (Config.enableSoundSystem() && (blockState = BlockStateUtils.blockDataToBlockState((block = event.getBlock()).getBlockData())) != MBlocks.AIR$defaultState && this.manager.isBlockSoundRemoved(ownerBlock = BlockStateUtils.getBlockOwner(blockState))) {
            if (player.getInventory().getItemInMainHand().getType() != Material.DEBUG_STICK) {
                try {
                    Object soundType = CoreReflections.field$BlockBehaviour$soundType.get(ownerBlock);
                    Object placeSound = CoreReflections.field$SoundType$placeSound.get(soundType);
                    player.playSound(block.getLocation(), FastNMS.INSTANCE.field$SoundEvent$location(placeSound).toString(), SoundCategory.BLOCKS, 1.0f, 0.8f);
                }
                catch (ReflectiveOperationException e) {
                    this.plugin.logger().warn("Failed to get sound type", e);
                }
            }
            return;
        }
        if (serverPlayer.shouldResendSound()) {
            try {
                block = event.getBlock();
                blockState = BlockStateUtils.blockDataToBlockState(block.getBlockData());
                ownerBlock = BlockStateUtils.getBlockOwner(blockState);
                Object soundType = CoreReflections.field$BlockBehaviour$soundType.get(ownerBlock);
                Object placeSound = CoreReflections.field$SoundType$placeSound.get(soundType);
                player.playSound(block.getLocation(), FastNMS.INSTANCE.field$SoundEvent$location(placeSound).toString(), SoundCategory.BLOCKS, 1.0f, 0.8f);
            }
            catch (ReflectiveOperationException e) {
                this.plugin.logger().warn("Failed to get sound type", e);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerBreak(BlockBreakEvent event) {
        Optional<CustomItem<ItemStack>> optionalCustomItem;
        Block block = event.getBlock();
        Object blockState = BlockStateUtils.blockDataToBlockState(block.getBlockData());
        int stateId = BlockStateUtils.blockStateToId(blockState);
        org.bukkit.entity.Player player = event.getPlayer();
        Location location = block.getLocation();
        BukkitServerPlayer serverPlayer = BukkitAdaptors.adapt(player);
        BukkitWorld world = new BukkitWorld(player.getWorld());
        WorldPosition position = new WorldPosition((World)world, (double)location.getBlockX() + 0.5, (double)location.getBlockY() + 0.5, (double)location.getBlockZ() + 0.5);
        Item<ItemStack> itemInHand = serverPlayer.getItemInHand(InteractionHand.MAIN_HAND);
        if (!ItemUtils.isEmpty(itemInHand) && (optionalCustomItem = itemInHand.getCustomItem()).isPresent()) {
            Cancellable cancellable = Cancellable.of(() -> ((BlockBreakEvent)event).isCancelled(), arg_0 -> ((BlockBreakEvent)event).setCancelled(arg_0));
            optionalCustomItem.get().execute(PlayerOptionalContext.of((Player)serverPlayer, ContextHolder.builder().withParameter(DirectContextParameters.BLOCK, new BukkitBlockInWorld(block)).withParameter(DirectContextParameters.POSITION, position).withParameter(DirectContextParameters.PLAYER, serverPlayer).withParameter(DirectContextParameters.EVENT, cancellable).withOptionalParameter(DirectContextParameters.ITEM_IN_HAND, itemInHand)), EventTrigger.BREAK);
            if (cancellable.isCancelled()) {
                return;
            }
        }
        if (!BlockStateUtils.isVanillaBlock(stateId)) {
            ImmutableBlockState state = this.manager.getImmutableBlockStateUnsafe(stateId);
            if (!state.isEmpty()) {
                if (!FastNMS.INSTANCE.field$Player$mayBuild(serverPlayer.serverPlayer()) && !serverPlayer.canBreak(LocationUtils.toBlockPos(location), null)) {
                    return;
                }
                CustomBlockBreakEvent customBreakEvent = new CustomBlockBreakEvent(serverPlayer, location, block, state);
                boolean isCancelled = EventUtils.fireAndCheckCancel((Event)customBreakEvent);
                if (isCancelled) {
                    event.setCancelled(true);
                    return;
                }
                Cancellable cancellable = Cancellable.of(() -> ((BlockBreakEvent)event).isCancelled(), arg_0 -> ((BlockBreakEvent)event).setCancelled(arg_0));
                PlayerOptionalContext context = PlayerOptionalContext.of((Player)serverPlayer, ContextHolder.builder().withParameter(DirectContextParameters.BLOCK, new BukkitBlockInWorld(block)).withParameter(DirectContextParameters.CUSTOM_BLOCK_STATE, state).withParameter(DirectContextParameters.EVENT, cancellable).withParameter(DirectContextParameters.POSITION, position).withOptionalParameter(DirectContextParameters.ITEM_IN_HAND, ItemUtils.isEmpty(itemInHand) ? null : itemInHand));
                state.owner().value().execute(context, EventTrigger.BREAK);
                if (cancellable.isCancelled()) {
                    return;
                }
                world.playBlockSound(position, state.settings().sounds().breakSound());
            }
        } else {
            Object ownerBlock;
            if (player.getGameMode() != GameMode.CREATIVE) {
                this.plugin.vanillaLootManager().getBlockLoot(stateId).ifPresent(it -> {
                    if (it.override()) {
                        event.setDropItems(false);
                        event.setExpToDrop(0);
                    }
                    ContextHolder lootContext = ContextHolder.builder().withParameter(DirectContextParameters.BLOCK, new BukkitBlockInWorld(block)).withParameter(DirectContextParameters.POSITION, position).withParameter(DirectContextParameters.PLAYER, serverPlayer).withOptionalParameter(DirectContextParameters.ITEM_IN_HAND, ItemUtils.isEmpty(itemInHand) ? null : itemInHand).build();
                    for (LootTable<?> lootTable : it.lootTables()) {
                        for (Item<?> item : lootTable.getRandomItems(lootContext, world, serverPlayer)) {
                            world.dropItemNaturally(position, item);
                        }
                    }
                });
            }
            if (Config.enableSoundSystem() && this.manager.isBlockSoundRemoved(ownerBlock = BlockStateUtils.getBlockOwner(blockState))) {
                try {
                    Object soundType = CoreReflections.field$BlockBehaviour$soundType.get(ownerBlock);
                    Object breakSound = CoreReflections.field$SoundType$breakSound.get(soundType);
                    block.getWorld().playSound(block.getLocation(), FastNMS.INSTANCE.field$SoundEvent$location(breakSound).toString(), SoundCategory.BLOCKS, 1.0f, 0.8f);
                }
                catch (ReflectiveOperationException e) {
                    this.plugin.logger().warn("Failed to get sound type", e);
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockBreakBlock(BlockBreakBlockEvent event) {
        Block block = event.getBlock();
        Object blockState = FastNMS.INSTANCE.method$BlockGetter$getBlockState(FastNMS.INSTANCE.field$CraftWorld$ServerLevel(block.getWorld()), LocationUtils.toBlockPos(block.getX(), block.getY(), block.getZ()));
        if (BlockStateUtils.isVanillaBlock(blockState)) {
            this.plugin.vanillaLootManager().getBlockLoot(BlockStateUtils.blockStateToId(blockState)).ifPresent(it -> {
                if (it.override()) {
                    event.getDrops().clear();
                    event.setExpToDrop(0);
                }
                Location location = block.getLocation();
                BukkitWorld world = new BukkitWorld(location.getWorld());
                WorldPosition position = new WorldPosition((World)world, (double)location.getBlockX() + 0.5, (double)location.getBlockY() + 0.5, (double)location.getBlockZ() + 0.5);
                ContextHolder.Builder builder = ContextHolder.builder().withParameter(DirectContextParameters.POSITION, position).withParameter(DirectContextParameters.BLOCK, new BukkitBlockInWorld(block));
                for (LootTable<?> lootTable : it.lootTables()) {
                    for (Item<?> item : lootTable.getRandomItems(builder.build(), world, null)) {
                        world.dropItemNaturally(position, item);
                    }
                }
            });
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onStep(GenericGameEvent event) {
        Object ownerBlock;
        if (event.getEvent() != GameEvent.STEP) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof org.bukkit.entity.Player)) {
            return;
        }
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)entity;
        BlockPos pos = EntityUtils.getOnPos(player);
        Block block = player.getWorld().getBlockAt(pos.x(), pos.y(), pos.z());
        Object blockState = FastNMS.INSTANCE.method$BlockGetter$getBlockState(FastNMS.INSTANCE.field$CraftWorld$ServerLevel(block.getWorld()), LocationUtils.toBlockPos(block.getX(), block.getY(), block.getZ()));
        Optional<ImmutableBlockState> optionalCustomState = BlockStateUtils.getOptionalCustomBlockState(blockState);
        if (optionalCustomState.isPresent()) {
            Location location = player.getLocation();
            ImmutableBlockState state = optionalCustomState.get();
            Cancellable cancellable = Cancellable.of(() -> ((GenericGameEvent)event).isCancelled(), arg_0 -> ((GenericGameEvent)event).setCancelled(arg_0));
            state.owner().value().execute(PlayerOptionalContext.of((Player)BukkitAdaptors.adapt(player), ContextHolder.builder().withParameter(DirectContextParameters.EVENT, cancellable).withParameter(DirectContextParameters.POSITION, new WorldPosition(new BukkitWorld(event.getWorld()), LocationUtils.toVec3d(location))).withParameter(DirectContextParameters.BLOCK, new BukkitBlockInWorld(block)).withParameter(DirectContextParameters.CUSTOM_BLOCK_STATE, state)), EventTrigger.STEP);
            if (cancellable.isCancelled()) {
                return;
            }
            player.playSound(location, state.settings().sounds().stepSound().id().toString(), SoundCategory.BLOCKS, ((Float)state.settings().sounds().stepSound().volume().get()).floatValue(), ((Float)state.settings().sounds().stepSound().pitch().get()).floatValue());
        } else if (Config.enableSoundSystem() && this.manager.isBlockSoundRemoved(ownerBlock = BlockStateUtils.getBlockOwner(blockState))) {
            try {
                Object soundType = CoreReflections.field$BlockBehaviour$soundType.get(ownerBlock);
                Object stepSound = CoreReflections.field$SoundType$stepSound.get(soundType);
                player.playSound(player.getLocation(), FastNMS.INSTANCE.field$SoundEvent$location(stepSound).toString(), SoundCategory.BLOCKS, 0.15f, 1.0f);
            }
            catch (ReflectiveOperationException e) {
                this.plugin.logger().warn("Failed to get sound type", e);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (!this.enableNoteBlockCheck) {
            return;
        }
        if (event.getChangedType() == Material.NOTE_BLOCK) {
            Block block = event.getBlock();
            Block sourceBlock = event.getSourceBlock();
            if (block.getX() == sourceBlock.getX() && block.getX() == sourceBlock.getZ()) {
                org.bukkit.World world = block.getWorld();
                Location location = block.getLocation();
                Object serverLevel = FastNMS.INSTANCE.field$CraftWorld$ServerLevel(world);
                Object chunkSource = FastNMS.INSTANCE.method$ServerLevel$getChunkSource(serverLevel);
                Object blockPos = LocationUtils.toBlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
                FastNMS.INSTANCE.method$ServerChunkCache$blockChanged(chunkSource, blockPos);
                if (block.getY() > sourceBlock.getY()) {
                    NoteBlockChainUpdateUtils.noteBlockChainUpdate(serverLevel, chunkSource, CoreReflections.instance$Direction$UP, blockPos, Config.maxNoteBlockChainUpdate());
                } else {
                    NoteBlockChainUpdateUtils.noteBlockChainUpdate(serverLevel, chunkSource, CoreReflections.instance$Direction$DOWN, blockPos, Config.maxNoteBlockChainUpdate());
                }
            }
        }
    }
}

