/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.momirealms.craftengine.bukkit.block.BlockEventListener;
import net.momirealms.craftengine.bukkit.block.BukkitBlockShape;
import net.momirealms.craftengine.bukkit.block.BukkitCustomBlock;
import net.momirealms.craftengine.bukkit.block.FallingBlockRemoveListener;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.injector.BlockGenerator;
import net.momirealms.craftengine.bukkit.plugin.network.PacketConsumers;
import net.momirealms.craftengine.bukkit.plugin.reflection.bukkit.CraftBukkitReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBlocks;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBuiltInRegistries;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MRegistries;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.bukkit.util.RegistryUtils;
import net.momirealms.craftengine.bukkit.util.TagUtils;
import net.momirealms.craftengine.core.block.AbstractBlockManager;
import net.momirealms.craftengine.core.block.BlockKeys;
import net.momirealms.craftengine.core.block.BlockRegistryMirror;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.DelegatingBlock;
import net.momirealms.craftengine.core.block.DelegatingBlockState;
import net.momirealms.craftengine.core.block.EmptyBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.behavior.EmptyBlockBehavior;
import net.momirealms.craftengine.core.block.parser.BlockStateParser;
import net.momirealms.craftengine.core.plugin.config.StringKeyConstructor;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.sound.SoundData;
import net.momirealms.craftengine.core.sound.Sounds;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MCUtils;
import net.momirealms.craftengine.core.util.Pair;
import net.momirealms.craftengine.core.util.ResourceKey;
import net.momirealms.craftengine.core.util.Tuple;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.chunk.PalettedContainer;
import net.momirealms.craftengine.libraries.snakeyaml.LoaderOptions;
import net.momirealms.craftengine.libraries.snakeyaml.Yaml;
import net.momirealms.craftengine.libraries.snakeyaml.constructor.BaseConstructor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BukkitBlockManager
extends AbstractBlockManager {
    private static BukkitBlockManager instance;
    private final BukkitCraftEngine plugin;
    private int customBlockCount;
    private ImmutableBlockState[] stateId2ImmutableBlockStates;
    private Map<Integer, Object> stateId2BlockHolder;
    private Map<Integer, Integer> blockAppearanceMapper;
    private Map<Key, Integer> registeredRealBlockSlots;
    private Set<Object> affectedSoundBlocks;
    private Map<Object, Pair<SoundData, SoundData>> affectedOpenableBlockSounds;
    private Map<Key, Key> soundMapper;
    private List<Key> blockRegisterOrder = new ObjectArrayList();
    private BlockEventListener blockEventListener;
    private FallingBlockRemoveListener fallingBlockRemoveListener;
    private Object cachedUpdateTagsPacket;
    private final List<Tuple<Object, Key, Boolean>> blocksToDeceive = new ArrayList<Tuple<Object, Key, Boolean>>();

    public BukkitBlockManager(BukkitCraftEngine plugin) {
        super(plugin);
        instance = this;
        this.plugin = plugin;
        this.initVanillaRegistry();
        this.loadMappingsAndAdditionalBlocks();
        this.registerBlocks();
        this.registerEmptyBlock();
    }

    @Override
    public void init() {
        this.initMirrorRegistry();
        this.deceiveBukkit();
        boolean enableNoteBlocks = this.blockAppearanceArranger.containsKey(BlockKeys.NOTE_BLOCK);
        this.blockEventListener = new BlockEventListener(this.plugin, this, enableNoteBlocks);
        if (enableNoteBlocks) {
            this.recordVanillaNoteBlocks();
        }
        this.fallingBlockRemoveListener = VersionHelper.isOrAbove1_20_3() ? new FallingBlockRemoveListener() : null;
        this.stateId2ImmutableBlockStates = new ImmutableBlockState[this.customBlockCount];
        Arrays.fill(this.stateId2ImmutableBlockStates, EmptyBlock.INSTANCE.defaultState());
        this.resetPacketConsumers();
    }

    @Override
    public String stateRegistryIdToStateSNBT(int id) {
        return BlockStateUtils.idToBlockState(id).toString();
    }

    public static BukkitBlockManager instance() {
        return instance;
    }

    public List<Key> blockRegisterOrder() {
        return Collections.unmodifiableList(this.blockRegisterOrder);
    }

    @Override
    public void delayedInit() {
        Bukkit.getPluginManager().registerEvents((Listener)this.blockEventListener, (Plugin)this.plugin.javaPlugin());
        if (this.fallingBlockRemoveListener != null) {
            Bukkit.getPluginManager().registerEvents((Listener)this.fallingBlockRemoveListener, (Plugin)this.plugin.javaPlugin());
        }
    }

    @Override
    public void unload() {
        super.unload();
        if (EmptyBlock.STATE != null) {
            Arrays.fill(this.stateId2ImmutableBlockStates, EmptyBlock.STATE);
        }
        for (DelegatingBlock block : this.registeredBlocks.values()) {
            block.behaviorDelegate().bindValue(EmptyBlockBehavior.INSTANCE);
            block.shapeDelegate().bindValue(BukkitBlockShape.STONE);
            DelegatingBlockState state = (DelegatingBlockState)FastNMS.INSTANCE.method$Block$defaultState(block);
            state.setBlockState(null);
        }
    }

    @Override
    public void disable() {
        this.unload();
        HandlerList.unregisterAll((Listener)this.blockEventListener);
        if (this.fallingBlockRemoveListener != null) {
            HandlerList.unregisterAll((Listener)this.fallingBlockRemoveListener);
        }
    }

    @Override
    public Map<Key, Key> soundMapper() {
        return this.soundMapper;
    }

    @Override
    public void delayedLoad() {
        this.resetPacketConsumers();
        super.delayedLoad();
    }

    @Override
    protected void resendTags() {
        if (this.clientBoundTags.equals(this.previousClientBoundTags)) {
            return;
        }
        ArrayList<TagUtils.TagEntry> list = new ArrayList<TagUtils.TagEntry>();
        for (Map.Entry entry : this.clientBoundTags.entrySet()) {
            list.add(new TagUtils.TagEntry((Integer)entry.getKey(), (List)entry.getValue()));
        }
        Object packet = TagUtils.createUpdateTagsPacket(Map.of(MRegistries.BLOCK, list));
        for (BukkitServerPlayer player : this.plugin.networkManager().onlineUsers()) {
            player.sendPacket(packet, false);
        }
        this.cachedUpdateTagsPacket = list.isEmpty() ? null : packet;
    }

    @Override
    @Nullable
    public BlockStateWrapper createPackedBlockState(String blockState) {
        ImmutableBlockState state = BlockStateParser.deserialize(blockState);
        if (state != null) {
            return state.customBlockState();
        }
        try {
            BlockData blockData = Bukkit.createBlockData((String)blockState);
            return BlockStateUtils.toPackedBlockState(blockData);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    public Object getMinecraftBlockHolder(int stateId) {
        return this.stateId2BlockHolder.get(stateId);
    }

    @Override
    @NotNull
    public ImmutableBlockState getImmutableBlockStateUnsafe(int stateId) {
        return this.stateId2ImmutableBlockStates[stateId - BlockStateUtils.vanillaStateSize()];
    }

    @Override
    @Nullable
    public ImmutableBlockState getImmutableBlockState(int stateId) {
        if (!BlockStateUtils.isVanillaBlock(stateId)) {
            return this.stateId2ImmutableBlockStates[stateId - BlockStateUtils.vanillaStateSize()];
        }
        return null;
    }

    @Override
    public void addBlockInternal(Key id, CustomBlock customBlock) {
        for (ImmutableBlockState state : customBlock.variantProvider().states()) {
            ImmutableBlockState previous = this.stateId2ImmutableBlockStates[state.customBlockState().registryId() - BlockStateUtils.vanillaStateSize()];
            if (previous != null && !previous.isEmpty()) {
                throw new LocalizedResourceConfigException("warning.config.block.state.bind_failed", state.toString(), previous.toString());
            }
            this.stateId2ImmutableBlockStates[state.customBlockState().registryId() - BlockStateUtils.vanillaStateSize()] = state;
            this.tempBlockAppearanceConvertor.put(state.customBlockState().registryId(), state.vanillaBlockState().registryId());
            this.appearanceToRealState.computeIfAbsent(state.vanillaBlockState().registryId(), k -> new IntArrayList()).add(state.customBlockState().registryId());
        }
        super.addBlockInternal(id, customBlock);
    }

    @Override
    public Key getBlockOwnerId(BlockStateWrapper state) {
        return BlockStateUtils.getBlockOwnerIdFromState(state.handle());
    }

    @Override
    protected Key getBlockOwnerId(int id) {
        return BlockStateUtils.getBlockOwnerIdFromState(BlockStateUtils.idToBlockState(id));
    }

    @Override
    public int availableAppearances(Key blockType) {
        return Optional.ofNullable(this.registeredRealBlockSlots.get(blockType)).orElse(0);
    }

    @NotNull
    public Map<Key, List<Integer>> blockAppearanceArranger() {
        return this.blockAppearanceArranger;
    }

    @NotNull
    public Map<Key, List<Integer>> realBlockArranger() {
        return this.realBlockArranger;
    }

    private void initMirrorRegistry() {
        int size = RegistryUtils.currentBlockRegistrySize();
        BlockStateWrapper[] states = new BlockStateWrapper[size];
        for (int i = 0; i < size; ++i) {
            states[i] = BlockStateWrapper.create(BlockStateUtils.idToBlockState(i), i, BlockStateUtils.isVanillaBlock(i));
        }
        BlockRegistryMirror.init(states, BlockStateWrapper.vanilla(MBlocks.STONE$defaultState, BlockStateUtils.blockStateToId(MBlocks.STONE$defaultState)));
    }

    private void registerEmptyBlock() {
        Holder.Reference<CustomBlock> holder = ((WritableRegistry)BuiltInRegistries.BLOCK).registerForHolder(ResourceKey.create(BuiltInRegistries.BLOCK.key().location(), Key.withDefaultNamespace("empty")));
        EmptyBlock emptyBlock = new EmptyBlock(Key.withDefaultNamespace("empty"), holder);
        holder.bindValue(emptyBlock);
    }

    private void resetPacketConsumers() {
        HashMap<Integer, Integer> finalMapping = new HashMap<Integer, Integer>(this.blockAppearanceMapper);
        int stoneId = BlockStateUtils.blockStateToId(MBlocks.STONE$defaultState);
        Iterator iterator = this.internalId2StateId.values().iterator();
        while (iterator.hasNext()) {
            int custom = (Integer)iterator.next();
            finalMapping.put(custom, stoneId);
        }
        finalMapping.putAll(this.tempBlockAppearanceConvertor);
        PacketConsumers.initBlocks(finalMapping, RegistryUtils.currentBlockRegistrySize());
    }

    private void initVanillaRegistry() {
        int vanillaStateCount = RegistryUtils.currentBlockRegistrySize();
        this.plugin.logger().info("Vanilla block count: " + vanillaStateCount);
        BlockStateUtils.init(vanillaStateCount);
    }

    @Override
    protected CustomBlock.Builder platformBuilder(Key id) {
        return BukkitCustomBlock.builder(id);
    }

    private void registerBlocks() {
        this.plugin.logger().info("Registering blocks. Please wait...");
        try {
            ImmutableMap.Builder builder1 = ImmutableMap.builder();
            ImmutableMap.Builder builder2 = ImmutableMap.builder();
            ImmutableMap.Builder builder3 = ImmutableMap.builder();
            ImmutableMap.Builder builder4 = ImmutableMap.builder();
            HashSet<Object> affectedBlockSounds = new HashSet<Object>();
            IdentityHashMap affectedDoors = new IdentityHashMap();
            HashSet<Object> affectedBlocks = new HashSet<Object>();
            ArrayList<Key> order = new ArrayList<Key>();
            this.unfreezeRegistry();
            int counter = 0;
            for (Map.Entry<Key, Integer> baseBlockAndItsCount : this.registeredRealBlockSlots.entrySet()) {
                counter = this.registerBlockVariants(baseBlockAndItsCount, counter, (ImmutableMap.Builder<Key, Integer>)builder1, (ImmutableMap.Builder<Integer, Object>)builder2, (ImmutableMap.Builder<Key, List<Integer>>)builder3, (ImmutableMap.Builder<Key, DelegatingBlock>)builder4, affectedBlockSounds, order);
            }
            this.freezeRegistry();
            this.plugin.logger().info("Registered block count: " + counter);
            this.customBlockCount = counter;
            this.internalId2StateId = builder1.build();
            this.stateId2BlockHolder = builder2.build();
            this.realBlockArranger = builder3.build();
            this.registeredBlocks = builder4.build();
            this.blockRegisterOrder = ImmutableList.copyOf(order);
            if (MCUtils.ceilLog2(BlockStateUtils.vanillaStateSize() + counter) == MCUtils.ceilLog2(BlockStateUtils.vanillaStateSize())) {
                PalettedContainer.NEED_DOWNGRADE = false;
            }
            for (Map.Entry<Key, Integer> block : (Iterable)MBuiltInRegistries.BLOCK) {
                Iterator<Field> state;
                Object soundType = CoreReflections.field$BlockBehaviour$soundType.get(block);
                if (!affectedBlockSounds.contains(soundType) || !BlockStateUtils.isVanillaBlock(state = FastNMS.INSTANCE.method$Block$defaultState(block))) continue;
                affectedBlocks.add(block);
            }
            affectedBlocks.remove(MBlocks.FIRE);
            affectedBlocks.remove(MBlocks.SOUL_FIRE);
            this.affectedSoundBlocks = ImmutableSet.copyOf(affectedBlocks);
            ImmutableMap.Builder soundMapperBuilder = ImmutableMap.builder();
            for (Object soundType : affectedBlockSounds) {
                for (Field field : List.of(CoreReflections.field$SoundType$placeSound, CoreReflections.field$SoundType$fallSound, CoreReflections.field$SoundType$hitSound, CoreReflections.field$SoundType$stepSound, CoreReflections.field$SoundType$breakSound)) {
                    Object soundEvent = field.get(soundType);
                    Key previousId = Key.of(FastNMS.INSTANCE.field$SoundEvent$location(soundEvent).toString());
                    soundMapperBuilder.put((Object)previousId, (Object)Key.of(previousId.namespace(), "replaced." + previousId.value()));
                }
            }
            Predicate<Key> predicate = it -> this.realBlockArranger.containsKey(it);
            Consumer<Key> soundCallback = s -> soundMapperBuilder.put(s, (Object)Key.of("replaced." + s.value()));
            BiConsumer<Object, Pair<SoundData, SoundData>> affectedBlockCallback = affectedDoors::put;
            Function<Key, SoundData> soundMapper = k -> SoundData.of(k, SoundData.SoundValue.FIXED_1, SoundData.SoundValue.ranged(0.9f, 1.0f));
            this.collectDoorSounds(predicate, Sounds.WOODEN_TRAPDOOR_OPEN, Sounds.WOODEN_TRAPDOOR_CLOSE, Sounds.WOODEN_TRAPDOORS, soundMapper, soundCallback, affectedBlockCallback);
            this.collectDoorSounds(predicate, Sounds.NETHER_WOOD_TRAPDOOR_OPEN, Sounds.NETHER_WOOD_TRAPDOOR_CLOSE, Sounds.NETHER_TRAPDOORS, soundMapper, soundCallback, affectedBlockCallback);
            this.collectDoorSounds(predicate, Sounds.BAMBOO_WOOD_TRAPDOOR_OPEN, Sounds.BAMBOO_WOOD_TRAPDOOR_CLOSE, Sounds.BAMBOO_TRAPDOORS, soundMapper, soundCallback, affectedBlockCallback);
            this.collectDoorSounds(predicate, Sounds.CHERRY_WOOD_TRAPDOOR_OPEN, Sounds.CHERRY_WOOD_TRAPDOOR_CLOSE, Sounds.CHERRY_TRAPDOORS, soundMapper, soundCallback, affectedBlockCallback);
            this.collectDoorSounds(predicate, Sounds.COPPER_TRAPDOOR_OPEN, Sounds.COPPER_TRAPDOOR_CLOSE, Sounds.COPPER_TRAPDOORS, soundMapper, soundCallback, affectedBlockCallback);
            this.collectDoorSounds(predicate, Sounds.WOODEN_DOOR_OPEN, Sounds.WOODEN_DOOR_CLOSE, Sounds.WOODEN_DOORS, soundMapper, soundCallback, affectedBlockCallback);
            this.collectDoorSounds(predicate, Sounds.NETHER_WOOD_DOOR_OPEN, Sounds.NETHER_WOOD_DOOR_CLOSE, Sounds.NETHER_DOORS, soundMapper, soundCallback, affectedBlockCallback);
            this.collectDoorSounds(predicate, Sounds.BAMBOO_WOOD_DOOR_OPEN, Sounds.BAMBOO_WOOD_DOOR_CLOSE, Sounds.BAMBOO_DOORS, soundMapper, soundCallback, affectedBlockCallback);
            this.collectDoorSounds(predicate, Sounds.CHERRY_WOOD_DOOR_OPEN, Sounds.CHERRY_WOOD_DOOR_CLOSE, Sounds.CHERRY_DOORS, soundMapper, soundCallback, affectedBlockCallback);
            this.collectDoorSounds(predicate, Sounds.COPPER_DOOR_OPEN, Sounds.COPPER_DOOR_CLOSE, Sounds.COPPER_DOORS, soundMapper, soundCallback, affectedBlockCallback);
            this.collectDoorSounds(predicate, Sounds.WOODEN_FENCE_GATE_OPEN, Sounds.WOODEN_FENCE_GATE_CLOSE, Sounds.WOODEN_FENCE_GATES, soundMapper, soundCallback, affectedBlockCallback);
            this.collectDoorSounds(predicate, Sounds.NETHER_WOOD_FENCE_GATE_OPEN, Sounds.NETHER_WOOD_FENCE_GATE_CLOSE, Sounds.NETHER_FENCE_GATES, soundMapper, soundCallback, affectedBlockCallback);
            this.collectDoorSounds(predicate, Sounds.BAMBOO_WOOD_FENCE_GATE_OPEN, Sounds.BAMBOO_WOOD_FENCE_GATE_CLOSE, Sounds.BAMBOO_FENCE_GATES, soundMapper, soundCallback, affectedBlockCallback);
            this.collectDoorSounds(predicate, Sounds.CHERRY_WOOD_FENCE_GATE_OPEN, Sounds.CHERRY_WOOD_FENCE_GATE_CLOSE, Sounds.CHERRY_FENCE_GATES, soundMapper, soundCallback, affectedBlockCallback);
            this.affectedOpenableBlockSounds = ImmutableMap.copyOf(affectedDoors);
            this.soundMapper = soundMapperBuilder.buildKeepingLast();
        }
        catch (Throwable e) {
            this.plugin.logger().warn("Failed to inject blocks.", e);
        }
    }

    private void collectDoorSounds(Predicate<Key> isUsedForCustomBlock, Key openSound, Key closeSound, List<Key> doors, Function<Key, SoundData> soundMapper, Consumer<Key> soundCallback, BiConsumer<Object, Pair<SoundData, SoundData>> affectedBlockCallback) {
        for (Key d : doors) {
            if (!isUsedForCustomBlock.test(d)) continue;
            soundCallback.accept(openSound);
            soundCallback.accept(closeSound);
            for (Key door : doors) {
                Object block = FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.BLOCK, KeyUtils.toResourceLocation(door));
                if (block == null) continue;
                affectedBlockCallback.accept(block, Pair.of(soundMapper.apply(Key.of("replaced." + openSound.value())), soundMapper.apply(Key.of("replaced." + closeSound.value()))));
            }
        }
    }

    public Object cachedUpdateTagsPacket() {
        return this.cachedUpdateTagsPacket;
    }

    private void loadMappingsAndAdditionalBlocks() {
        InputStream is;
        Path additionalFile;
        this.plugin.logger().info("Loading mappings.yml.");
        Path mappingsFile = this.plugin.dataFolderPath().resolve("mappings.yml");
        if (!Files.exists(mappingsFile, new LinkOption[0])) {
            this.plugin.saveResource("mappings.yml");
        }
        if (!Files.exists(additionalFile = this.plugin.dataFolderPath().resolve("additional-real-blocks.yml"), new LinkOption[0])) {
            this.plugin.saveResource("additional-real-blocks.yml");
        }
        Yaml yaml = new Yaml((BaseConstructor)new StringKeyConstructor(mappingsFile, new LoaderOptions()));
        LinkedHashMap<Key, Integer> blockTypeCounter = new LinkedHashMap<Key, Integer>();
        try {
            is = Files.newInputStream(mappingsFile, new OpenOption[0]);
            try {
                Map<String, String> blockStateMappings = this.loadBlockStateMappings((Map)yaml.load(is));
                this.validateBlockStateMappings(mappingsFile, blockStateMappings);
                Int2ObjectOpenHashMap stateMap = new Int2ObjectOpenHashMap();
                Int2IntOpenHashMap appearanceMapper = new Int2IntOpenHashMap();
                HashMap<Key, List<Integer>> appearanceArranger = new HashMap<Key, List<Integer>>();
                for (Map.Entry<String, String> entry : blockStateMappings.entrySet()) {
                    this.processBlockStateMapping(mappingsFile, entry, (Map<Integer, String>)stateMap, blockTypeCounter, (Map<Integer, Integer>)appearanceMapper, appearanceArranger);
                }
                this.blockAppearanceMapper = ImmutableMap.copyOf((Map)appearanceMapper);
                this.blockAppearanceArranger = ImmutableMap.copyOf(appearanceArranger);
                this.plugin.logger().info("Freed " + this.blockAppearanceMapper.size() + " block state appearances.");
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to init mappings.yml", e);
        }
        try {
            is = Files.newInputStream(additionalFile, new OpenOption[0]);
            try {
                this.registeredRealBlockSlots = this.buildRegisteredRealBlockSlots(blockTypeCounter, (Map)yaml.load(is));
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to init additional-real-blocks.yml", e);
        }
    }

    private void recordVanillaNoteBlocks() {
        try {
            Object resourceLocation = KeyUtils.toResourceLocation(BlockKeys.NOTE_BLOCK);
            Object block = FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.BLOCK, resourceLocation);
            Object stateDefinition = CoreReflections.field$Block$StateDefinition.get(block);
            ImmutableList states = (ImmutableList)CoreReflections.field$StateDefinition$states.get(stateDefinition);
            for (Object state : states) {
                BlockStateUtils.CLIENT_SIDE_NOTE_BLOCKS.put(state, new Object());
            }
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to init vanilla note block", e);
        }
    }

    @Nullable
    public Key replaceSoundIfExist(Key id) {
        return this.soundMapper.get(id);
    }

    public boolean isBlockSoundRemoved(Object block) {
        return this.affectedSoundBlocks.contains(block);
    }

    public boolean isOpenableBlockSoundRemoved(Object block) {
        return this.affectedOpenableBlockSounds.containsKey(block);
    }

    public SoundData getRemovedOpenableBlockSound(Object block, boolean open) {
        return open ? this.affectedOpenableBlockSounds.get(block).left() : this.affectedOpenableBlockSounds.get(block).right();
    }

    private Map<String, String> loadBlockStateMappings(Map<String, Object> mappings) {
        LinkedHashMap<String, String> blockStateMappings = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : mappings.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof String)) continue;
            String afterValue = (String)object;
            blockStateMappings.put(entry.getKey(), afterValue);
        }
        return blockStateMappings;
    }

    private void validateBlockStateMappings(Path mappingFile, Map<String, String> blockStateMappings) {
        HashMap<String, String> temp = new HashMap<String, String>(blockStateMappings);
        for (Map.Entry entry : temp.entrySet()) {
            String state = (String)entry.getValue();
            if (!blockStateMappings.containsKey(state)) continue;
            String after = blockStateMappings.remove(state);
            this.plugin.logger().warn(mappingFile, "'" + state + ": " + after + "' is invalid because '" + state + "' has already been used as a base block.");
        }
    }

    private void processBlockStateMapping(Path mappingFile, Map.Entry<String, String> entry, Map<Integer, String> stateMap, Map<Key, Integer> counter, Map<Integer, Integer> mapper, Map<Key, List<Integer>> arranger) {
        Object before = this.createBlockState(mappingFile, entry.getKey());
        Object after = this.createBlockState(mappingFile, entry.getValue());
        if (before == null || after == null) {
            return;
        }
        int beforeId = BlockStateUtils.blockStateToId(before);
        int afterId = BlockStateUtils.blockStateToId(after);
        Integer previous = mapper.put(beforeId, afterId);
        if (previous == null) {
            Key key = this.blockOwnerFromString(entry.getKey());
            counter.compute(key, (k, count) -> count == null ? 1 : count + 1);
            stateMap.put(beforeId, entry.getKey());
            stateMap.put(afterId, entry.getValue());
            arranger.computeIfAbsent(key, k -> new IntArrayList()).add(beforeId);
        } else {
            String previousState = stateMap.get(previous);
            this.plugin.logger().warn(mappingFile, "Duplicate entry: '" + previousState + "' equals '" + entry.getKey() + "'");
        }
    }

    private Key blockOwnerFromString(String stateString) {
        int index = stateString.indexOf(91);
        if (index == -1) {
            return Key.of(stateString);
        }
        return Key.of(stateString.substring(0, index));
    }

    private Object createBlockState(Path mappingFile, String state) {
        try {
            Object registryOrLookUp = MBuiltInRegistries.BLOCK;
            if (CoreReflections.method$Registry$asLookup != null) {
                registryOrLookUp = CoreReflections.method$Registry$asLookup.invoke(registryOrLookUp, new Object[0]);
            }
            Object result = CoreReflections.method$BlockStateParser$parseForBlock.invoke(null, registryOrLookUp, state, false);
            return CoreReflections.method$BlockStateParser$BlockResult$blockState.invoke(result, new Object[0]);
        }
        catch (Exception e) {
            this.plugin.logger().warn(mappingFile, "'" + state + "' is not a valid block state.");
            return null;
        }
    }

    private LinkedHashMap<Key, Integer> buildRegisteredRealBlockSlots(Map<Key, Integer> counter, Map<String, Object> additionalYaml) {
        LinkedHashMap<Key, Integer> map = new LinkedHashMap<Key, Integer>(counter);
        for (Map.Entry<String, Object> entry : additionalYaml.entrySet()) {
            Key blockType = Key.of(entry.getKey());
            Object object = entry.getValue();
            if (!(object instanceof Integer)) continue;
            Integer i = (Integer)object;
            int previous = map.getOrDefault(blockType, 0);
            if (previous == 0) {
                map.put(blockType, i);
                this.plugin.logger().info("Loaded " + String.valueOf(blockType) + " with " + i + " real block states");
                continue;
            }
            map.put(blockType, i + previous);
            this.plugin.logger().info("Loaded " + String.valueOf(blockType) + " with " + previous + " appearances and " + (i + previous) + " real block states");
        }
        return map;
    }

    private void unfreezeRegistry() throws IllegalAccessException {
        CoreReflections.field$MappedRegistry$frozen.set(MBuiltInRegistries.BLOCK, false);
        CoreReflections.field$MappedRegistry$unregisteredIntrusiveHolders.set(MBuiltInRegistries.BLOCK, new IdentityHashMap());
    }

    private void freezeRegistry() throws IllegalAccessException {
        CoreReflections.field$MappedRegistry$frozen.set(MBuiltInRegistries.BLOCK, true);
    }

    private int registerBlockVariants(Map.Entry<Key, Integer> blockWithCount, int counter, ImmutableMap.Builder<Key, Integer> builder1, ImmutableMap.Builder<Integer, Object> builder2, ImmutableMap.Builder<Key, List<Integer>> builder3, ImmutableMap.Builder<Key, DelegatingBlock> builder4, Set<Object> affectSoundTypes, List<Key> order) throws Exception {
        Key clientSideBlockType = blockWithCount.getKey();
        boolean isNoteBlock = clientSideBlockType.equals(BlockKeys.NOTE_BLOCK);
        Object clientSideBlock = this.getBlockFromRegistry(this.createResourceLocation(clientSideBlockType));
        int amount = blockWithCount.getValue();
        IntArrayList stateIds = new IntArrayList();
        for (int i = 0; i < amount; ++i) {
            Object newRealBlock;
            Key realBlockKey = this.createRealBlockKey(clientSideBlockType, i);
            Object blockProperties = this.createBlockProperties(realBlockKey);
            Object resourceLocation = this.createResourceLocation(realBlockKey);
            try {
                newRealBlock = BlockGenerator.generateBlock(clientSideBlockType, clientSideBlock, blockProperties);
            }
            catch (Throwable throwable) {
                this.plugin.logger().warn("Failed to generate dynamic block class", throwable);
                continue;
            }
            Object blockHolder = CoreReflections.method$Registry$registerForHolder.invoke(null, MBuiltInRegistries.BLOCK, resourceLocation, newRealBlock);
            CoreReflections.method$Holder$Reference$bindValue.invoke(blockHolder, newRealBlock);
            CoreReflections.field$Holder$Reference$tags.set(blockHolder, Set.of());
            Object newBlockState = FastNMS.INSTANCE.method$Block$defaultState(newRealBlock);
            CoreReflections.method$IdMapper$add.invoke(CoreReflections.instance$Block$BLOCK_STATE_REGISTRY, newBlockState);
            if (isNoteBlock) {
                BlockStateUtils.CLIENT_SIDE_NOTE_BLOCKS.put(newBlockState, new Object());
            }
            int stateId = BlockStateUtils.vanillaStateSize() + counter;
            builder1.put((Object)realBlockKey, (Object)stateId);
            builder2.put((Object)stateId, blockHolder);
            builder4.put((Object)realBlockKey, (Object)((DelegatingBlock)newRealBlock));
            stateIds.add(stateId);
            this.blocksToDeceive.add(Tuple.of(newRealBlock, clientSideBlockType, isNoteBlock));
            order.add(realBlockKey);
            ++counter;
        }
        builder3.put((Object)clientSideBlockType, (Object)stateIds);
        Object soundType = CoreReflections.field$BlockBehaviour$soundType.get(clientSideBlock);
        affectSoundTypes.add(soundType);
        return counter;
    }

    private Object createResourceLocation(Key key) {
        return FastNMS.INSTANCE.method$ResourceLocation$fromNamespaceAndPath(key.namespace(), key.value());
    }

    private Object getBlockFromRegistry(Object resourceLocation) {
        return FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.BLOCK, resourceLocation);
    }

    private Key createRealBlockKey(Key replacedBlock, int index) {
        return Key.of("craftengine", replacedBlock.value() + "_" + index);
    }

    private Object createBlockProperties(Key realBlockKey) throws Exception {
        Object blockProperties = CoreReflections.method$BlockBehaviour$Properties$of.invoke(null, new Object[0]);
        Object realBlockResourceLocation = this.createResourceLocation(realBlockKey);
        Object realBlockResourceKey = CoreReflections.method$ResourceKey$create.invoke(null, MRegistries.BLOCK, realBlockResourceLocation);
        if (CoreReflections.field$BlockBehaviour$Properties$id != null) {
            CoreReflections.field$BlockBehaviour$Properties$id.set(blockProperties, realBlockResourceKey);
        }
        return blockProperties;
    }

    private void deceiveBukkit() {
        try {
            Map magicMap = (Map)CraftBukkitReflections.field$CraftMagicNumbers$BLOCK_MATERIAL.get(null);
            Map factories = (Map)CraftBukkitReflections.field$CraftBlockStates$FACTORIES.get(null);
            for (Tuple<Object, Key, Boolean> tuple : this.blocksToDeceive) {
                this.deceiveBukkit(tuple.left(), tuple.mid(), tuple.right(), magicMap, factories);
            }
            this.blocksToDeceive.clear();
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to deceive bukkit", e);
        }
    }

    private void deceiveBukkit(Object newBlock, Key replacedBlock, boolean isNoteBlock, Map<Object, Material> magicMap, Map<Material, Object> factories) {
        if (isNoteBlock) {
            magicMap.put(newBlock, Material.STONE);
        } else {
            Material material = (Material)Registry.MATERIAL.get(new NamespacedKey(replacedBlock.namespace(), replacedBlock.value()));
            if (CraftBukkitReflections.clazz$CraftBlockStates$BlockEntityStateFactory.isInstance(factories.get(material))) {
                magicMap.put(newBlock, Material.STONE);
            } else {
                magicMap.put(newBlock, material);
            }
        }
    }

    @Override
    protected int getBlockRegistryId(Key id) {
        Object block = FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.BLOCK, KeyUtils.toResourceLocation(id));
        return FastNMS.INSTANCE.method$IdMap$getId(MBuiltInRegistries.BLOCK, block).orElseThrow(() -> new IllegalStateException("Block " + String.valueOf(id) + " not found"));
    }

    @Override
    protected boolean isVanillaBlock(Key id) {
        if (!id.namespace().equals("minecraft")) {
            return false;
        }
        if (id.value().equals("air")) {
            return true;
        }
        return FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.BLOCK, KeyUtils.toResourceLocation(id)) != MBlocks.AIR;
    }
}

