/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.papi;

import java.util.Optional;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.momirealms.craftengine.core.font.BitmapImage;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.util.FormatUtils;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageExpansion
extends PlaceholderExpansion {
    private final CraftEngine plugin;

    public ImageExpansion(CraftEngine plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "image";
    }

    @NotNull
    public String getAuthor() {
        return "XiaoMoMi";
    }

    @NotNull
    public String getVersion() {
        return "1.0";
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        int codepoint;
        Key key;
        String[] split = params.split("_", 2);
        if (split.length != 2) {
            return null;
        }
        String[] param = split[1].split(":", 4);
        if (param.length < 2) {
            return null;
        }
        try {
            key = Key.of(param[0], param[1]);
        }
        catch (IllegalArgumentException e) {
            this.plugin.logger().warn("Invalid image namespaced key: " + param[0] + ":" + param[1]);
            return null;
        }
        Optional<BitmapImage> optional = this.plugin.fontManager().bitmapImageByImageId(key);
        if (optional.isEmpty()) {
            return null;
        }
        BitmapImage image = optional.get();
        if (param.length == 4) {
            codepoint = image.codepointAt(Integer.parseInt(param[2]), Integer.parseInt(param[3]));
        } else if (param.length == 3) {
            codepoint = image.codepointAt(Integer.parseInt(param[2]), 0);
        } else if (param.length == 2) {
            codepoint = image.codepointAt(0, 0);
        } else {
            return null;
        }
        try {
            switch (split[0]) {
                case "mm": 
                case "minimessage": 
                case "mini": {
                    return FormatUtils.miniMessageFont(new String(Character.toChars(codepoint)), image.font().toString());
                }
                case "md": 
                case "minedown": {
                    return FormatUtils.mineDownFont(new String(Character.toChars(codepoint)), image.font().toString());
                }
                case "raw": {
                    return new String(Character.toChars(codepoint));
                }
            }
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }
}

