/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.skript.condition;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import net.momirealms.craftengine.bukkit.api.CraftEngineItems;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="Is CraftEngine Item")
@Description(value={"Checks if the Item is CraftEngine item."})
@Since(value={"1.0"})
public class CondIsCustomItem
extends Condition {
    private Expression<?> item;

    public static void register() {
        Skript.registerCondition(CondIsCustomItem.class, (String[])new String[]{"%itemstack/itemtype/slot% (is [a[n]]|are) (custom|ce|craft-engine) item[s]", "%itemstack/itemtype/slot% (isn't|is not|aren't|are not) [a[n]] (custom|ce|craft-engine) item[s]"});
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.item = expressions[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        Object single = this.item.getSingle(event);
        ItemStack checkItemStack = null;
        if (single instanceof ItemType) {
            ItemType itemType = (ItemType)single;
            checkItemStack = ((ItemData)itemType.getTypes().getFirst()).getStack();
        } else if (single instanceof ItemStack) {
            ItemStack itemStack;
            checkItemStack = itemStack = (ItemStack)single;
        } else if (single instanceof Slot) {
            Slot slot = (Slot)single;
            checkItemStack = slot.getItem();
        }
        if (checkItemStack == null) {
            return this.isNegated();
        }
        boolean exists = CraftEngineItems.isCustomItem(checkItemStack);
        if (!exists) {
            return this.isNegated();
        }
        return !this.isNegated();
    }

    public String toString(@Nullable Event event, boolean debug) {
        return PropertyCondition.toString((Condition)this, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.BE, (Event)event, (boolean)debug, this.item, (String)"itemtypes");
    }
}

