/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.skript.event;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.ClickEventTracker;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import java.util.function.Predicate;
import net.momirealms.craftengine.bukkit.api.event.CustomBlockInteractEvent;
import net.momirealms.craftengine.bukkit.api.event.FurnitureInteractEvent;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.UnsafeBlockStateMatcher;
import net.momirealms.craftengine.core.entity.player.InteractionHand;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

@Name(value="On Click on Custom Block and Furniture")
@Description(value={"Fires when click on custom block and furniture"})
@Since(value={"1.0"})
public class EvtCustomClick
extends SkriptEvent {
    private static final int RIGHT = 1;
    private static final int LEFT = 2;
    private static final int ANY = 3;
    public static final ClickEventTracker interactTracker = new ClickEventTracker((JavaPlugin)Skript.getInstance());
    @Nullable
    private Literal<?> type;
    @Nullable
    private Literal<ItemType> tools;
    private int click = 3;

    public static void register() {
        Skript.registerEvent((String)"Interact Custom Block Furniture", EvtCustomClick.class, (Class[])new Class[]{CustomBlockInteractEvent.class, FurnitureInteractEvent.class}, (String[])new String[]{"[(1:right|2:left)(| |-)][mouse(| |-)]click[ing] of (ce|craft-engine) [on %-unsafeblockstatematchers/strings%] [(with|using|holding) %-itemtype%]", "[(1:right|2:left)(| |-)][mouse(| |-)]click[ing] of (ce|craft-engine) (with|using|holding) %itemtype% on %unsafeblockstatematchers/strings%"});
        EventValues.registerEventValue(CustomBlockInteractEvent.class, Location.class, CustomBlockInteractEvent::location, (int)0);
        EventValues.registerEventValue(CustomBlockInteractEvent.class, Player.class, CustomBlockInteractEvent::player, (int)0);
        EventValues.registerEventValue(CustomBlockInteractEvent.class, Block.class, CustomBlockInteractEvent::bukkitBlock, (int)0);
        EventValues.registerEventValue(CustomBlockInteractEvent.class, Entity.class, event -> null, (int)0);
        EventValues.registerEventValue(CustomBlockInteractEvent.class, World.class, event -> event.location().getWorld(), (int)0);
        EventValues.registerEventValue(FurnitureInteractEvent.class, Location.class, FurnitureInteractEvent::location, (int)0);
        EventValues.registerEventValue(FurnitureInteractEvent.class, Player.class, FurnitureInteractEvent::player, (int)0);
        EventValues.registerEventValue(CustomBlockInteractEvent.class, Block.class, event -> null, (int)0);
        EventValues.registerEventValue(FurnitureInteractEvent.class, Entity.class, event -> event.furniture().baseEntity(), (int)0);
        EventValues.registerEventValue(FurnitureInteractEvent.class, World.class, event -> event.location().getWorld(), (int)0);
    }

    public boolean check(Event event) {
        ImmutableBlockState block;
        String furnitureId;
        if (event instanceof CustomBlockInteractEvent) {
            EquipmentSlot hand;
            int click;
            CustomBlockInteractEvent interactEvent = (CustomBlockInteractEvent)event;
            furnitureId = null;
            CustomBlockInteractEvent.Action action = interactEvent.action();
            switch (action) {
                case LEFT_CLICK: {
                    click = 2;
                    break;
                }
                case RIGHT_CLICK: {
                    click = 1;
                    break;
                }
                default: {
                    return false;
                }
            }
            if ((this.click & click) == 0) {
                return false;
            }
            EquipmentSlot equipmentSlot = hand = interactEvent.hand() == InteractionHand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
            if (!interactTracker.checkEvent(interactEvent.getPlayer(), (Cancellable)interactEvent, hand)) {
                return false;
            }
            block = interactEvent.blockState();
        } else if (event instanceof FurnitureInteractEvent) {
            FurnitureInteractEvent interactEvent = (FurnitureInteractEvent)event;
            furnitureId = interactEvent.furniture().id().toString();
            block = null;
            if ((this.click & 1) == 0) {
                return false;
            }
        } else {
            return false;
        }
        Predicate<ItemType> checker = itemType -> {
            if (event instanceof CustomBlockInteractEvent) {
                CustomBlockInteractEvent event1 = (CustomBlockInteractEvent)event;
                return itemType.isOfType(event1.item());
            }
            if (event instanceof FurnitureInteractEvent) {
                FurnitureInteractEvent event1 = (FurnitureInteractEvent)event;
                return itemType.isOfType(event1.player().getInventory().getItem(event1.hand() == InteractionHand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND));
            }
            return false;
        };
        if (this.tools != null && !this.tools.check(event, checker)) {
            return false;
        }
        if (this.type != null) {
            return this.type.check(event, object -> {
                if (object instanceof String) {
                    String id = (String)object;
                    if (furnitureId != null) {
                        return id.equals(furnitureId);
                    }
                }
                if (object instanceof UnsafeBlockStateMatcher) {
                    UnsafeBlockStateMatcher matcher = (UnsafeBlockStateMatcher)object;
                    if (block != null) {
                        return matcher.matches(block);
                    }
                }
                return false;
            });
        }
        return true;
    }

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.click = parseResult.mark == 0 ? 3 : parseResult.mark;
        this.type = args[matchedPattern];
        this.tools = args[1 - matchedPattern];
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return (switch (this.click) {
            case 2 -> "left";
            case 1 -> "right";
            default -> "";
        }) + "click" + (String)(this.type != null ? " on " + this.type.toString(event, debug) : "") + (String)(this.tools != null ? " holding " + this.tools.toString(event, debug) : "");
    }
}

