/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.skript.expression;

import ch.njol.skript.expressions.base.SimplePropertyExpression;
import java.util.Optional;
import net.momirealms.craftengine.bukkit.api.CraftEngineBlocks;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.Nullable;

public class ExprBlockCustomBlockID
extends SimplePropertyExpression<Object, String> {
    public static void register() {
        ExprBlockCustomBlockID.register(ExprBlockCustomBlockID.class, String.class, (String)"(custom|ce|craft-engine) block [namespace] id", (String)"blocks/blockdata/customblockstates");
    }

    @Nullable
    public String convert(Object object) {
        if (object instanceof ImmutableBlockState) {
            ImmutableBlockState immutableBlockState = (ImmutableBlockState)object;
            return immutableBlockState.owner().value().id().toString();
        }
        if (object instanceof CustomBlock) {
            CustomBlock customBlock = (CustomBlock)object;
            return customBlock.id().toString();
        }
        if (object instanceof Block) {
            Block block = (Block)object;
            return Optional.ofNullable(CraftEngineBlocks.getCustomBlockState(block)).map(it -> it.owner().value().id().toString()).orElse(null);
        }
        if (object instanceof BlockData) {
            BlockData blockData = (BlockData)object;
            return Optional.ofNullable(CraftEngineBlocks.getCustomBlockState(blockData)).map(it -> it.owner().value().id().toString()).orElse(null);
        }
        return null;
    }

    protected String getPropertyName() {
        return "custom block id";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }
}

